/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceTextComponentBorder
implements Border,
UIResource {
    protected Insets myInsets;
    private static LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("SubstanceTextComponentBorder");

    public SubstanceTextComponentBorder(Insets insets) {
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    private void paintBorder(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        float f = 2.0f * SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(jComponent));
        JTextComponent jTextComponent = SubstanceCoreUtilities.getTextComponentForTransitions(jComponent);
        if (jTextComponent != null) {
            TextUI textUI = jTextComponent.getUI();
            if (textUI instanceof TransitionAwareUI) {
                TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)textUI);
                StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
                StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
                Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
                ComponentState componentState = modelStateInfo.getCurrModelState();
                if (componentState.isDisabled()) {
                    componentState = ComponentState.DISABLED_SELECTED;
                }
                if (n3 * n4 < 100000) {
                    SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jTextComponent, ColorSchemeAssociationKind.BORDER, componentState);
                    HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(SubstanceSizeUtils.getComponentFontSize(jComponent), n3, n4, Float.valueOf(f), substanceColorScheme.getDisplayName());
                    BufferedImage bufferedImage = smallImageCache.get(hashMapKey);
                    float f2 = SubstanceColorSchemeUtilities.getAlpha(jComponent, componentState);
                    if (bufferedImage == null) {
                        bufferedImage = SubstanceCoreUtilities.getBlankImage(n3, n4);
                        Graphics2D graphics2D2 = bufferedImage.createGraphics();
                        SubstanceImageCreator.paintTextComponentBorder(jComponent, graphics2D2, 0, 0, n3, n4, f, substanceColorScheme);
                        graphics2D2.dispose();
                        smallImageCache.put(hashMapKey, bufferedImage);
                    }
                    graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2));
                    graphics2D.drawImage((Image)bufferedImage, n, n2, null);
                    if (!componentState.isDisabled() && map.size() > 1) {
                        for (Map.Entry entry : map.entrySet()) {
                            float f3;
                            ComponentState componentState2 = (ComponentState)entry.getKey();
                            if (componentState2 == componentState || (f3 = ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution()) == 0.0f) continue;
                            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jTextComponent, ColorSchemeAssociationKind.BORDER, componentState2);
                            HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(SubstanceSizeUtils.getComponentFontSize(jComponent), n3, n4, Float.valueOf(f), substanceColorScheme2.getDisplayName());
                            BufferedImage bufferedImage2 = smallImageCache.get(hashMapKey2);
                            float f4 = SubstanceColorSchemeUtilities.getAlpha(jComponent, componentState2);
                            if (bufferedImage2 == null) {
                                bufferedImage2 = SubstanceCoreUtilities.getBlankImage(n3, n4);
                                Graphics2D graphics2D3 = bufferedImage2.createGraphics();
                                SubstanceImageCreator.paintTextComponentBorder(jComponent, graphics2D3, 0, 0, n3, n4, f, substanceColorScheme2);
                                graphics2D3.dispose();
                                smallImageCache.put(hashMapKey2, bufferedImage2);
                            }
                            graphics2D.setComposite(AlphaComposite.SrcOver.derive(f4 * f3));
                            graphics2D.drawImage((Image)bufferedImage2, n, n2, null);
                        }
                    }
                } else {
                    graphics2D.translate(n, n2);
                    SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jTextComponent, ColorSchemeAssociationKind.BORDER, componentState);
                    float f5 = SubstanceColorSchemeUtilities.getAlpha(jComponent, componentState);
                    graphics2D.setComposite(AlphaComposite.SrcOver.derive(f5));
                    SubstanceImageCreator.paintSimpleBorder(jComponent, graphics2D, n3, n4, substanceColorScheme);
                    if (!componentState.isDisabled() && map.size() > 1) {
                        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                            float f6;
                            ComponentState componentState3 = entry.getKey();
                            if (componentState3 == componentState || (f6 = entry.getValue().getContribution()) == 0.0f) continue;
                            SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(jTextComponent, ColorSchemeAssociationKind.BORDER, componentState3);
                            float f7 = SubstanceColorSchemeUtilities.getAlpha(jComponent, componentState3);
                            graphics2D.setComposite(AlphaComposite.SrcOver.derive(f7 * f6));
                            SubstanceImageCreator.paintSimpleBorder(jComponent, graphics2D, n3, n4, substanceColorScheme3);
                        }
                    }
                }
            }
        } else {
            ComponentState componentState = bl ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jComponent, ColorSchemeAssociationKind.BORDER, componentState);
            if (n3 * n4 < 100000) {
                HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(SubstanceSizeUtils.getComponentFontSize(jComponent), n3, n4, Float.valueOf(f), substanceColorScheme.getDisplayName());
                BufferedImage bufferedImage = smallImageCache.get(hashMapKey);
                if (bufferedImage == null) {
                    bufferedImage = SubstanceCoreUtilities.getBlankImage(n3, n4);
                    Graphics2D graphics2D4 = bufferedImage.createGraphics();
                    SubstanceImageCreator.paintTextComponentBorder(jComponent, graphics2D4, 0, 0, n3, n4, f, substanceColorScheme);
                    graphics2D4.dispose();
                    smallImageCache.put(hashMapKey, bufferedImage);
                }
                graphics2D.drawImage((Image)bufferedImage, n, n2, null);
            } else {
                graphics2D.translate(n, n2);
                SubstanceImageCreator.paintSimpleBorder(jComponent, graphics2D, n3, n4, substanceColorScheme);
            }
        }
        graphics2D.dispose();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder((JComponent)component, graphics, n, n2, n3, n4, component.isEnabled(), component.hasFocus());
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

