/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.text.LockBorder;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;

public class SubstanceTextUtilities {
    public static final String ENFORCE_FG_COLOR = "substancelaf.internal.textUtilities.enforceFgColor";

    public static void paintTextWithDropShadow(JComponent jComponent, Graphics graphics, Color color, String string, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
        graphics2D2.setFont(graphics2D.getFont());
        graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        float f = SubstanceColorUtilities.getColorStrength(color);
        graphics2D2.setColor(SubstanceColorUtilities.getNegativeColor(color));
        ConvolveOp convolveOp = new ConvolveOp(new Kernel(3, 3, new float[]{0.02f, 0.05f, 0.02f, 0.05f, 0.02f, 0.05f, 0.02f, 0.05f, 0.02f}), 1, null);
        graphics2D2.drawString(string, n3, n4 - 1);
        bufferedImage = convolveOp.filter(bufferedImage, null);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(jComponent, f, graphics));
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jComponent, graphics));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        SubstanceTextUtilities.paintText(graphics2D, jComponent, new Rectangle(n3, n4 - fontMetrics.getAscent(), n - n3, fontMetrics.getHeight()), string, -1, graphics2D.getFont(), color, graphics2D.getClipBounds());
        graphics2D.dispose();
    }

    private static void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string, int n, Font font, Color color, Rectangle rectangle2, AffineTransform affineTransform) {
        if (string == null || string.length() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        if (rectangle2 != null) {
            graphics2D.clip(rectangle2);
        }
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics2D, string, n, rectangle.x, rectangle.y + graphics2D.getFontMetrics().getAscent());
        graphics2D.dispose();
    }

    public static void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string, int n, Font font, Color color, Rectangle rectangle2) {
        SubstanceTextUtilities.paintText(graphics, jComponent, rectangle, string, n, font, color, rectangle2, null);
    }

    public static void paintVerticalText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string, int n, Font font, Color color, Rectangle rectangle2, boolean bl) {
        if (string == null || string.length() == 0) {
            return;
        }
        AffineTransform affineTransform = null;
        if (!bl) {
            affineTransform = AffineTransform.getTranslateInstance(rectangle.x + rectangle.width, rectangle.y);
            affineTransform.rotate(1.5707963267948966);
        } else {
            affineTransform = AffineTransform.getTranslateInstance(rectangle.x, rectangle.y + rectangle.height);
            affineTransform.rotate(-1.5707963267948966);
        }
        Rectangle rectangle3 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        SubstanceTextUtilities.paintText(graphics, jComponent, rectangle3, string, n, font, color, rectangle2, affineTransform);
    }

    public static void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string, int n) {
        SubstanceTextUtilities.paintText(graphics, abstractButton, abstractButton.getModel(), rectangle, string, n);
    }

    public static void paintText(Graphics graphics, AbstractButton abstractButton, ButtonModel buttonModel, Rectangle rectangle, String string, int n) {
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)abstractButton.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        float f = SubstanceColorSchemeUtilities.getAlpha(abstractButton, ComponentState.getState(abstractButton));
        if (abstractButton instanceof JMenuItem) {
            SubstanceTextUtilities.paintMenuItemText(graphics, (JMenuItem)abstractButton, rectangle, string, n, stateTransitionTracker.getModelStateInfo(), f);
        } else {
            SubstanceTextUtilities.paintText(graphics, (JComponent)abstractButton, rectangle, string, n, stateTransitionTracker.getModelStateInfo(), f);
        }
    }

    public static void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string, int n, ComponentState componentState, float f) {
        Color color = SubstanceTextUtilities.getForegroundColor(jComponent, string, componentState, f);
        SubstanceTextUtilities.paintText(graphics, jComponent, rectangle, string, n, jComponent.getFont(), color, null);
    }

    public static void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string, int n, StateTransitionTracker.ModelStateInfo modelStateInfo, float f) {
        Color color = SubstanceTextUtilities.getForegroundColor(jComponent, string, modelStateInfo, f);
        SubstanceTextUtilities.paintText(graphics, jComponent, rectangle, string, n, jComponent.getFont(), color, null);
    }

    public static void paintMenuItemText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string, int n, StateTransitionTracker.ModelStateInfo modelStateInfo, float f) {
        Color color = SubstanceTextUtilities.getMenuComponentForegroundColor(jMenuItem, string, modelStateInfo, f);
        SubstanceTextUtilities.paintText(graphics, jMenuItem, rectangle, string, n, jMenuItem.getFont(), color, null);
    }

    public static Color getForegroundColor(JComponent jComponent, String string, ComponentState componentState, float f) {
        Color color;
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl = SwingUtilities.getAncestorOfClass(CellRendererPane.class, jComponent) != null || Boolean.TRUE.equals(jComponent.getClientProperty(ENFORCE_FG_COLOR));
        Color color2 = color = bl ? jComponent.getForeground() : SubstanceColorSchemeUtilities.getColorScheme(jComponent, componentState).getForegroundColor();
        if (f < 1.0f) {
            Color color3 = SubstanceColorUtilities.getBackgroundFillColor(jComponent);
            color = SubstanceColorUtilities.getInterpolatedColor(color, color3, f);
        }
        return color;
    }

    public static Color getForegroundColor(JComponent jComponent, String string, StateTransitionTracker.ModelStateInfo modelStateInfo, float f) {
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl = SwingUtilities.getAncestorOfClass(CellRendererPane.class, jComponent) != null || Boolean.TRUE.equals(jComponent.getClientProperty(ENFORCE_FG_COLOR));
        Color color = null;
        color = bl ? jComponent.getForeground() : SubstanceColorUtilities.getForegroundColor(jComponent, modelStateInfo);
        if (f < 1.0f) {
            Color color2 = SubstanceColorUtilities.getBackgroundFillColor(jComponent);
            color = SubstanceColorUtilities.getInterpolatedColor(color, color2, f);
        }
        return color;
    }

    public static Color getMenuComponentForegroundColor(Component component, String string, StateTransitionTracker.ModelStateInfo modelStateInfo, float f) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Color color = SubstanceColorUtilities.getMenuComponentForegroundColor(component, modelStateInfo);
        if (f < 1.0f) {
            Color color2 = SubstanceColorUtilities.getBackgroundFillColor(component);
            color = SubstanceColorUtilities.getInterpolatedColor(color, color2, f);
        }
        return color;
    }

    public static void paintTextCompBackground(Graphics graphics, JComponent jComponent) {
        Color color = SubstanceTextUtilities.getTextBackgroundFillColor(jComponent);
        boolean bl = SubstanceLookAndFeel.getCurrentSkin(jComponent).getWatermark() != null && (SubstanceCoreUtilities.toDrawWatermark(jComponent) || !jComponent.isOpaque());
        SubstanceTextUtilities.paintTextCompBackground(graphics, jComponent, color, bl);
    }

    public static Color getTextBackgroundFillColor(JComponent jComponent) {
        TextUI textUI;
        Color color = SubstanceColorUtilities.getBackgroundFillColor(jComponent);
        JTextComponent jTextComponent = SubstanceCoreUtilities.getTextComponentForTransitions(jComponent);
        if (jTextComponent != null && (textUI = jTextComponent.getUI()) instanceof TransitionAwareUI) {
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)textUI);
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            Color color2 = SubstanceColorUtilities.getOuterTextComponentBorderColor(color);
            color2 = SubstanceColorUtilities.getInterpolatedColor(color2, color, 0.6);
            float f = stateTransitionTracker.getFacetStrength(ComponentStateFacet.SELECTION);
            float f2 = stateTransitionTracker.getFacetStrength(ComponentStateFacet.ROLLOVER);
            color = SubstanceColorUtilities.getInterpolatedColor(color2, color, Math.max(f, f2));
        }
        return color;
    }

    private static void paintTextCompBackground(Graphics graphics, JComponent jComponent, Color color, boolean bl) {
        Object object;
        Object object2;
        boolean bl2;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = SubstanceSizeUtils.getComponentFontSize(jComponent);
        int n2 = (int)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(n));
        Border border = jComponent.getBorder();
        if (border instanceof LockBorder) {
            border = ((LockBorder)border).getOriginalBorder();
        }
        if (!(bl2 = border instanceof SubstanceTextComponentBorder)) {
            object2 = border;
            while (object2 instanceof CompoundBorder) {
                object = ((CompoundBorder)object2).getOutsideBorder();
                if (object instanceof SubstanceTextComponentBorder) {
                    bl2 = true;
                    break;
                }
                Border border2 = ((CompoundBorder)object2).getInsideBorder();
                if (border2 instanceof SubstanceTextComponentBorder) {
                    bl2 = true;
                    break;
                }
                object2 = border2;
            }
        }
        object2 = bl2 ? SubstanceOutlineUtilities.getBaseOutline(jComponent.getWidth(), jComponent.getHeight(), Math.max(0.0f, 2.0f * SubstanceSizeUtils.getClassicButtonCornerRadius(n) - (float)n2), null, n2) : new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
        BackgroundPaintingUtils.update(graphics, jComponent, false);
        object = SubstanceCoreUtilities.getSkin(jComponent).getWatermark();
        if (object != null) {
            object.drawWatermarkImage(graphics2D, jComponent, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        graphics2D.setColor(color);
        graphics2D.fill((Shape)object2);
        if (bl && object != null) {
            graphics2D.clip((Shape)object2);
            object.drawWatermarkImage(graphics2D, jComponent, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        graphics2D.dispose();
    }
}

