/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceSplitPaneUI;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class SubstanceSplitPaneDivider
extends BasicSplitPaneDivider
implements TransitionAwareUI {
    private RolloverControlListener substanceRolloverListener;
    protected StateTransitionTracker stateTransitionTracker;
    private PropertyChangeListener substancePropertyChangeListener;
    private ButtonModel gripModel;

    public SubstanceSplitPaneDivider(SubstanceSplitPaneUI substanceSplitPaneUI) {
        super(substanceSplitPaneUI);
        this.setLayout(new SubstanceDividerLayout());
    }

    @Override
    public void setBasicSplitPaneUI(BasicSplitPaneUI basicSplitPaneUI) {
        if (this.splitPane != null) {
            this.uninstall();
        }
        if (basicSplitPaneUI != null) {
            this.splitPane = basicSplitPaneUI.getSplitPane();
            this.gripModel = new DefaultButtonModel();
            this.gripModel.setArmed(false);
            this.gripModel.setSelected(false);
            this.gripModel.setPressed(false);
            this.gripModel.setRollover(false);
            this.gripModel.setEnabled(this.splitPane.isEnabled());
            this.stateTransitionTracker = new StateTransitionTracker(this.splitPane, this.gripModel);
            this.substanceRolloverListener = new RolloverControlListener(this, this.gripModel);
            this.addMouseListener(this.substanceRolloverListener);
            this.addMouseMotionListener(this.substanceRolloverListener);
            this.substancePropertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        boolean bl = SubstanceSplitPaneDivider.this.splitPane.isEnabled();
                        SubstanceSplitPaneDivider.this.gripModel.setEnabled(bl);
                        if (SubstanceSplitPaneDivider.this.leftButton != null) {
                            SubstanceSplitPaneDivider.this.leftButton.setEnabled(bl);
                        }
                        if (SubstanceSplitPaneDivider.this.rightButton != null) {
                            SubstanceSplitPaneDivider.this.rightButton.setEnabled(bl);
                        }
                        SubstanceSplitPaneDivider.this.setEnabled(bl);
                    }
                }
            };
            this.splitPane.addPropertyChangeListener(this.substancePropertyChangeListener);
            this.stateTransitionTracker.registerModelListeners();
        } else {
            this.uninstall();
        }
        super.setBasicSplitPaneUI(basicSplitPaneUI);
    }

    private void uninstall() {
        this.removeMouseListener(this.substanceRolloverListener);
        this.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        if (this.substancePropertyChangeListener != null) {
            this.splitPane.removePropertyChangeListener(this.substancePropertyChangeListener);
            this.substancePropertyChangeListener = null;
        }
        this.stateTransitionTracker.unregisterModelListeners();
    }

    @Override
    public void paint(Graphics graphics) {
        if (SubstanceCoreUtilities.hasFlatAppearance(this.splitPane, true)) {
            BackgroundPaintingUtils.updateIfOpaque(graphics, this.splitPane);
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.stateTransitionTracker.getModelStateInfo();
        ComponentState componentState = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        float f = SubstanceColorSchemeUtilities.getAlpha(this.splitPane, componentState);
        int n = SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this), 30, 1, 2, false);
        int n2 = SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this), 40, 1, 3, false);
        if (this.splitPane.getOrientation() == 1) {
            int n3 = this.getHeight();
            if (n3 >= n) {
                int n4 = n3 / 4;
                if (n4 > n2) {
                    n4 = n2;
                }
                int n5 = this.getWidth();
                int n6 = 0;
                int n7 = (n3 - n4) / 2;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                    float f2 = entry.getValue().getContribution();
                    if (f2 == 0.0f) continue;
                    ComponentState componentState2 = entry.getKey();
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.splitPane, f * f2, graphics));
                    SubstanceImageCreator.paintSplitDividerBumpImage(graphics2D, this, n6, n7, n5, n4, false, SubstanceColorSchemeUtilities.getColorScheme(this, ColorSchemeAssociationKind.MARK, componentState2));
                }
            }
        } else {
            int n8 = this.getWidth();
            if (n8 >= n) {
                int n9 = n8 / 4;
                if (n9 > n2) {
                    n9 = n2;
                }
                int n10 = this.getHeight();
                int n11 = (n8 - n9) / 2;
                int n12 = 1;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                    float f3 = entry.getValue().getContribution();
                    if (f3 == 0.0f) continue;
                    ComponentState componentState3 = entry.getKey();
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.splitPane, f * f3, graphics));
                    SubstanceImageCreator.paintSplitDividerBumpImage(graphics2D, this, n11, n12, n9, n10, true, SubstanceColorSchemeUtilities.getColorScheme(this, ColorSchemeAssociationKind.MARK, componentState3));
                }
            }
        }
        graphics2D.dispose();
        super.paint(graphics);
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        JButton jButton = new JButton(){

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        TransitionAwareIcon transitionAwareIcon = new TransitionAwareIcon(jButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                int n = SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane);
                return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(n), SubstanceSizeUtils.getSplitPaneArrowIconHeight(n), SubstanceSizeUtils.getArrowStrokeWidth(n), 1, substanceColorScheme);
            }
        }, "substance.splitPane.left.vertical");
        TransitionAwareIcon transitionAwareIcon2 = new TransitionAwareIcon(jButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                int n = SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane);
                return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(n), SubstanceSizeUtils.getSplitPaneArrowIconHeight(n), SubstanceSizeUtils.getArrowStrokeWidth(n), 7, substanceColorScheme);
            }
        }, "substance.splitPane.left.horizontal");
        jButton.setIcon(this.splitPane.getOrientation() == 0 ? transitionAwareIcon : transitionAwareIcon2);
        jButton.putClientProperty("substancelaf.buttonpaintnever", Boolean.TRUE);
        jButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        jButton.setRequestFocusEnabled(false);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        return jButton;
    }

    @Override
    protected JButton createRightOneTouchButton() {
        JButton jButton = new JButton(){

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        TransitionAwareIcon transitionAwareIcon = new TransitionAwareIcon(jButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                int n = SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane);
                return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(n), SubstanceSizeUtils.getSplitPaneArrowIconHeight(n), SubstanceSizeUtils.getArrowStrokeWidth(n), 5, substanceColorScheme);
            }
        }, "substance.splitPane.right.vertical");
        TransitionAwareIcon transitionAwareIcon2 = new TransitionAwareIcon(jButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                int n = SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane);
                return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(n), SubstanceSizeUtils.getSplitPaneArrowIconHeight(n), SubstanceSizeUtils.getArrowStrokeWidth(n), 3, substanceColorScheme);
            }
        }, "substance.splitPane.right.horizontal");
        jButton.setIcon(this.splitPane.getOrientation() == 0 ? transitionAwareIcon : transitionAwareIcon2);
        jButton.putClientProperty("substancelaf.buttonpaintnever", Boolean.TRUE);
        jButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    public void updateOneTouchButtons(int n) {
        if (n == 0) {
            if (this.leftButton != null) {
                this.leftButton.setIcon(new TransitionAwareIcon(this.leftButton, new TransitionAwareIcon.Delegate(){

                    @Override
                    public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                        int n = SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane);
                        return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(n), SubstanceSizeUtils.getSplitPaneArrowIconHeight(n), SubstanceSizeUtils.getArrowStrokeWidth(n), 1, substanceColorScheme);
                    }
                }, "substance.splitPane.left.vertical"));
            }
            if (this.rightButton != null) {
                this.rightButton.setIcon(new TransitionAwareIcon(this.rightButton, new TransitionAwareIcon.Delegate(){

                    @Override
                    public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                        int n = SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane);
                        return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(n), SubstanceSizeUtils.getSplitPaneArrowIconHeight(n), SubstanceSizeUtils.getArrowStrokeWidth(n), 5, substanceColorScheme);
                    }
                }, "substance.splitPane.right.vertical"));
            }
        } else {
            if (this.leftButton != null) {
                this.leftButton.setIcon(new TransitionAwareIcon(this.leftButton, new TransitionAwareIcon.Delegate(){

                    @Override
                    public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                        int n = SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane);
                        return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(n), SubstanceSizeUtils.getSplitPaneArrowIconHeight(n), SubstanceSizeUtils.getArrowStrokeWidth(n), 7, substanceColorScheme);
                    }
                }, "substance.splitPane.left.horizontal"));
            }
            if (this.rightButton != null) {
                this.rightButton.setIcon(new TransitionAwareIcon(this.rightButton, new TransitionAwareIcon.Delegate(){

                    @Override
                    public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                        int n = SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane);
                        return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(n), SubstanceSizeUtils.getSplitPaneArrowIconHeight(n), SubstanceSizeUtils.getArrowStrokeWidth(n), 3, substanceColorScheme);
                    }
                }, "substance.splitPane.right.horizontal"));
            }
        }
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    protected class SubstanceDividerLayout
    extends BasicSplitPaneDivider.DividerLayout {
        protected SubstanceDividerLayout() {
            super(SubstanceSplitPaneDivider.this);
        }

        @Override
        public void layoutContainer(Container container) {
            if (SubstanceSplitPaneDivider.this.leftButton != null && SubstanceSplitPaneDivider.this.rightButton != null && container == SubstanceSplitPaneDivider.this) {
                if (SubstanceSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = SubstanceSplitPaneDivider.this.getInsets();
                    if (SubstanceSplitPaneDivider.this.orientation == 0) {
                        int n = insets != null ? insets.left : 0;
                        int n2 = SubstanceSplitPaneDivider.this.getHeight();
                        if (insets != null) {
                            n2 -= insets.top + insets.bottom;
                            n2 = Math.max(n2, 0);
                        }
                        int n3 = (container.getSize().height - n2) / 2;
                        int n4 = SubstanceSizeUtils.getSplitPaneButtonOffset(SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane));
                        SubstanceSplitPaneDivider.this.leftButton.setBounds(n + n4, n3, ((SubstanceSplitPaneDivider)SubstanceSplitPaneDivider.this).leftButton.getPreferredSize().width * 2 / 3, n2);
                        SubstanceSplitPaneDivider.this.rightButton.setBounds(SubstanceSplitPaneDivider.this.leftButton.getX() + SubstanceSplitPaneDivider.this.leftButton.getWidth(), n3, ((SubstanceSplitPaneDivider)SubstanceSplitPaneDivider.this).rightButton.getPreferredSize().width * 2 / 3, n2);
                    } else {
                        int n = insets != null ? insets.top : 0;
                        int n5 = SubstanceSplitPaneDivider.this.getWidth();
                        if (insets != null) {
                            n5 -= insets.left + insets.right;
                            n5 = Math.max(n5, 0);
                        }
                        int n6 = (container.getSize().width - n5) / 2;
                        int n7 = SubstanceSizeUtils.getSplitPaneButtonOffset(SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane));
                        SubstanceSplitPaneDivider.this.leftButton.setBounds(n6, n + n7, n5, ((SubstanceSplitPaneDivider)SubstanceSplitPaneDivider.this).leftButton.getPreferredSize().height * 2 / 3);
                        SubstanceSplitPaneDivider.this.rightButton.setBounds(n6, SubstanceSplitPaneDivider.this.leftButton.getY() + SubstanceSplitPaneDivider.this.leftButton.getHeight(), n5, ((SubstanceSplitPaneDivider)SubstanceSplitPaneDivider.this).leftButton.getPreferredSize().height * 2 / 3);
                    }
                } else {
                    SubstanceSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    SubstanceSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }
    }
}

