/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.RolloverButtonListener;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollButton;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public class ButtonVisualStateTracker {
    private RolloverButtonListener substanceButtonListener;
    protected PropertyChangeListener substancePropertyListener;
    protected StateTransitionTracker stateTransitionTracker;

    public void installListeners(final AbstractButton abstractButton, boolean bl) {
        this.stateTransitionTracker = new StateTransitionTracker(abstractButton, abstractButton.getModel());
        if (abstractButton instanceof SubstanceScrollButton) {
            this.stateTransitionTracker.setRepaintCallback(new StateTransitionTracker.RepaintCallback(){

                public SwingRepaintCallback getRepaintCallback() {
                    JScrollBar jScrollBar = (JScrollBar)SwingUtilities.getAncestorOfClass(JScrollBar.class, abstractButton);
                    if (jScrollBar != null) {
                        return new SwingRepaintCallback((Component)jScrollBar);
                    }
                    return new SwingRepaintCallback((Component)abstractButton);
                }
            });
        }
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        if (bl) {
            this.substanceButtonListener = new RolloverButtonListener(abstractButton, this.stateTransitionTracker);
            abstractButton.addMouseListener(this.substanceButtonListener);
            abstractButton.addMouseMotionListener(this.substanceButtonListener);
            abstractButton.addFocusListener(this.substanceButtonListener);
            abstractButton.addPropertyChangeListener(this.substanceButtonListener);
            abstractButton.addChangeListener(this.substanceButtonListener);
        }
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("model".equals(propertyChangeEvent.getPropertyName())) {
                    ButtonVisualStateTracker.this.stateTransitionTracker.setModel((ButtonModel)propertyChangeEvent.getNewValue());
                }
            }
        };
        abstractButton.addPropertyChangeListener(this.substancePropertyListener);
    }

    public void uninstallListeners(AbstractButton abstractButton) {
        if (this.substanceButtonListener != null) {
            abstractButton.removeMouseListener(this.substanceButtonListener);
            abstractButton.removeMouseMotionListener(this.substanceButtonListener);
            abstractButton.removeFocusListener(this.substanceButtonListener);
            abstractButton.removePropertyChangeListener(this.substanceButtonListener);
            abstractButton.removeChangeListener(this.substanceButtonListener);
            this.substanceButtonListener = null;
        }
        abstractButton.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
    }

    public StateTransitionTracker getStateTransitionTracker() {
        return this.stateTransitionTracker;
    }
}

