/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.RectangularButtonShaper;
import org.pushingpixels.substance.api.shaper.StandardButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.ModificationAwareUI;
import org.pushingpixels.substance.internal.animation.RootPaneDefaultButtonTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.PairwiseButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.Sideable;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.trident.Timeline;

public class ButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> regularBackgrounds = new LazyResettableHashMap("ButtonBackgroundDelegate");

    public static BufferedImage getFullAlphaBackground(AbstractButton abstractButton, ButtonModel buttonModel, SubstanceButtonShaper substanceButtonShaper, SubstanceFillPainter substanceFillPainter, SubstanceBorderPainter substanceBorderPainter, int n, int n2) {
        Object object;
        Object object2;
        Object object3;
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)abstractButton.getUI());
        StateTransitionTracker.ModelStateInfo modelStateInfo = transitionAwareUI.getTransitionTracker().getModelStateInfo();
        ComponentState componentState = modelStateInfo.getCurrModelState();
        float f = 0.0f;
        if (abstractButton instanceof JButton && RootPaneDefaultButtonTracker.isPulsating((JButton)(object3 = (JButton)abstractButton)) && componentState != ComponentState.PRESSED_SELECTED && componentState != ComponentState.PRESSED_UNSELECTED) {
            f = RootPaneDefaultButtonTracker.getTimelinePosition((JButton)object3);
        }
        object3 = SubstanceCoreUtilities.getSides(abstractButton, "substancelaf.buttonside");
        boolean bl = StandardButtonShaper.isRoundButton(abstractButton);
        float f2 = 0.0f;
        if (substanceButtonShaper instanceof RectangularButtonShaper) {
            f2 = ((RectangularButtonShaper)((Object)substanceButtonShaper)).getCornerRadius(abstractButton, null);
        }
        Set<SubstanceConstants.Side> set = SubstanceCoreUtilities.getSides(abstractButton, "substancelaf.buttonopenSide");
        boolean bl2 = abstractButton.isContentAreaFilled();
        boolean bl3 = abstractButton.isBorderPainted();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(abstractButton, ColorSchemeAssociationKind.BORDER, componentState);
        if (abstractButton.getUI() instanceof ModificationAwareUI && (object2 = (object = (ModificationAwareUI)((Object)abstractButton.getUI())).getModificationTimeline()) != null && object2.getState() != Timeline.TimelineState.IDLE) {
            HashMapKey hashMapKey;
            BufferedImage bufferedImage;
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.YELLOW;
            SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.ORANGE;
            f = object2.getTimelinePosition();
            HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(n, n2, substanceColorScheme3.getDisplayName(), substanceColorScheme.getDisplayName(), substanceButtonShaper.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), object3, set, abstractButton.getClass().getName(), bl, Float.valueOf(f2), bl2, bl3, SubstanceSizeUtils.getComponentFontSize(abstractButton));
            BufferedImage bufferedImage2 = regularBackgrounds.get(hashMapKey2);
            if (bufferedImage2 == null) {
                bufferedImage2 = ButtonBackgroundDelegate.createBackgroundImage(abstractButton, substanceButtonShaper, substanceFillPainter, substanceBorderPainter, n, n2, substanceColorScheme3, substanceColorScheme, set, bl2, bl3);
                regularBackgrounds.put(hashMapKey2, bufferedImage2);
            }
            if ((bufferedImage = regularBackgrounds.get(hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, substanceColorScheme2.getDisplayName(), substanceColorScheme.getDisplayName(), substanceButtonShaper.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), object3, set, abstractButton.getClass().getName(), bl, Float.valueOf(f2), bl2, bl3, SubstanceSizeUtils.getComponentFontSize(abstractButton)))) == null) {
                bufferedImage = ButtonBackgroundDelegate.createBackgroundImage(abstractButton, substanceButtonShaper, substanceFillPainter, substanceBorderPainter, n, n2, substanceColorScheme2, substanceColorScheme, set, bl2, bl3);
                regularBackgrounds.put(hashMapKey, bufferedImage);
            }
            BufferedImage bufferedImage3 = SubstanceCoreUtilities.getBlankImage(n, n2);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            if (f < 1.0f) {
                graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
            }
            if (f > 0.0f) {
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(f));
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            }
            graphics2D.dispose();
            return bufferedImage3;
        }
        object = modelStateInfo.getStateContributionMap();
        object2 = SubstanceColorSchemeUtilities.getColorScheme(abstractButton, componentState);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, object2.getDisplayName(), substanceColorScheme.getDisplayName(), substanceButtonShaper.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), object3, set, abstractButton.getClass().getName(), bl, (int)(1000.0f * f2), bl2, bl3, SubstanceSizeUtils.getComponentFontSize(abstractButton));
        BufferedImage bufferedImage = regularBackgrounds.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = ButtonBackgroundDelegate.createBackgroundImage(abstractButton, substanceButtonShaper, substanceFillPainter, substanceBorderPainter, n, n2, (SubstanceColorScheme)object2, substanceColorScheme, set, bl2, bl3);
            regularBackgrounds.put(hashMapKey, bufferedImage);
        }
        if (componentState.isDisabled() || object.size() == 1) {
            return bufferedImage;
        }
        BufferedImage bufferedImage4 = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = bufferedImage4.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        for (Map.Entry entry : object.entrySet()) {
            float f3;
            ComponentState componentState2 = (ComponentState)entry.getKey();
            if (componentState2 == componentState || !((f3 = ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution()) > 0.0f)) continue;
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(f3));
            SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(abstractButton, componentState2);
            SubstanceColorScheme substanceColorScheme5 = SubstanceColorSchemeUtilities.getColorScheme(abstractButton, ColorSchemeAssociationKind.BORDER, componentState2);
            HashMapKey hashMapKey3 = SubstanceCoreUtilities.getHashKey(n, n2, substanceColorScheme4.getDisplayName(), substanceColorScheme5.getDisplayName(), substanceButtonShaper.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), object3, set, abstractButton.getClass().getName(), bl, (int)(1000.0f * f2), bl2, bl3, SubstanceSizeUtils.getComponentFontSize(abstractButton));
            BufferedImage bufferedImage5 = regularBackgrounds.get(hashMapKey3);
            if (bufferedImage5 == null) {
                bufferedImage5 = ButtonBackgroundDelegate.createBackgroundImage(abstractButton, substanceButtonShaper, substanceFillPainter, substanceBorderPainter, n, n2, substanceColorScheme4, substanceColorScheme5, set, bl2, bl3);
                regularBackgrounds.put(hashMapKey3, bufferedImage5);
            }
            graphics2D.drawImage((Image)bufferedImage5, 0, 0, null);
        }
        graphics2D.dispose();
        return bufferedImage4;
    }

    private static BufferedImage createBackgroundImage(AbstractButton abstractButton, SubstanceButtonShaper substanceButtonShaper, SubstanceFillPainter substanceFillPainter, SubstanceBorderPainter substanceBorderPainter, int n, int n2, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, Set<SubstanceConstants.Side> set, boolean bl, boolean bl2) {
        int n3 = (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(abstractButton)));
        int n4 = set != null && set.contains((Object)SubstanceConstants.Side.LEFT) ? n3 : 0;
        int n5 = set != null && set.contains((Object)SubstanceConstants.Side.RIGHT) ? n3 : 0;
        int n6 = set != null && set.contains((Object)SubstanceConstants.Side.TOP) ? n3 : 0;
        int n7 = set != null && set.contains((Object)SubstanceConstants.Side.BOTTOM) ? n3 : 0;
        int n8 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(abstractButton)) / 2.0);
        Shape shape = substanceButtonShaper.getButtonOutline(abstractButton, new Insets(n8, n8, n8, n8), n + n4 + n5, n2 + n6 + n7, false);
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.translate(-n4, -n6);
        if (bl) {
            substanceFillPainter.paintContourBackground(graphics2D, abstractButton, n + n4 + n5, n2 + n6 + n7, shape, false, substanceColorScheme, true);
        }
        if (bl2) {
            int n9 = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(abstractButton));
            Shape shape2 = substanceBorderPainter.isPaintingInnerContour() ? substanceButtonShaper.getButtonOutline(abstractButton, new Insets(n8 + n9, n8 + n9, n8 + n9, n8 + n9), n + n4 + n5, n2 + n6 + n7, true) : null;
            substanceBorderPainter.paintBorder(graphics2D, abstractButton, n + n4 + n5, n2 + n6 + n7, shape, shape2, substanceColorScheme2);
        }
        return bufferedImage;
    }

    public void updateBackground(Graphics graphics, AbstractButton abstractButton) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        if (SubstanceCoreUtilities.isButtonNeverPainted(abstractButton)) {
            return;
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        int n3 = 0;
        if (SubstanceCoreUtilities.isScrollButton(abstractButton) || SubstanceCoreUtilities.isSpinnerButton(abstractButton)) {
            Sideable sideable = (Sideable)((Object)abstractButton);
            PairwiseButtonBackgroundDelegate.updatePairwiseBackground(graphics, abstractButton, n, n2, sideable.getSide(), false);
            return;
        }
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(abstractButton);
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(abstractButton);
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(abstractButton);
        BufferedImage bufferedImage = ButtonBackgroundDelegate.getFullAlphaBackground(abstractButton, abstractButton.getModel(), substanceButtonShaper, substanceFillPainter, substanceBorderPainter, n, n2);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)abstractButton.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        boolean bl = SubstanceCoreUtilities.hasFlatAppearance(abstractButton);
        boolean bl2 = bl || !abstractButton.isEnabled();
        float f = 1.0f;
        if (bl2) {
            if (bl) {
                f = 0.0f;
                for (Map.Entry entry : map.entrySet()) {
                    ComponentState componentState = (ComponentState)entry.getKey();
                    if (componentState.isDisabled() || componentState == ComponentState.ENABLED) continue;
                    f += ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution();
                }
            } else if (!abstractButton.isEnabled()) {
                f = SubstanceColorSchemeUtilities.getAlpha(abstractButton, modelStateInfo.getCurrModelState());
            }
        }
        if (f > 0.0f) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(abstractButton, f, graphics));
            graphics2D.drawImage((Image)bufferedImage, 0, n3, null);
            graphics2D.dispose();
        }
    }

    public static boolean isRoundButton(AbstractButton abstractButton) {
        return !SubstanceCoreUtilities.isComboBoxButton(abstractButton) && !SubstanceCoreUtilities.isScrollButton(abstractButton) && SubstanceCoreUtilities.hasText(abstractButton);
    }

    public static boolean contains(AbstractButton abstractButton, int n, int n2) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return false;
        }
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(abstractButton);
        if (substanceButtonShaper == null) {
            return false;
        }
        Shape shape = substanceButtonShaper.getButtonOutline(abstractButton, null, abstractButton.getWidth(), abstractButton.getHeight(), false);
        return shape.contains(n, n2);
    }

    static String getMemoryUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubstanceBackgroundDelegate: \n");
        stringBuffer.append("\t" + regularBackgrounds.size() + " regular");
        return stringBuffer.toString();
    }
}

