/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.socks;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.proxy.handlers.socks.AbstractSocksLogicHandler;
import org.apache.mina.proxy.handlers.socks.SocksProxyConstants;
import org.apache.mina.proxy.handlers.socks.SocksProxyRequest;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.proxy.utils.ByteUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks4LogicHandler
extends AbstractSocksLogicHandler {
    private static final Logger logger = LoggerFactory.getLogger(Socks4LogicHandler.class);

    public Socks4LogicHandler(ProxyIoSession proxyIoSession) {
        super(proxyIoSession);
    }

    public void doHandshake(IoFilter.NextFilter nextFilter) {
        logger.debug(" doHandshake()");
        this.writeRequest(nextFilter, this.request);
    }

    protected void writeRequest(IoFilter.NextFilter nextFilter, SocksProxyRequest socksProxyRequest) {
        try {
            boolean bl = socksProxyRequest.getHost() != null;
            byte[] byArray = socksProxyRequest.getUserName().getBytes("ASCII");
            byte[] byArray2 = bl ? socksProxyRequest.getHost().getBytes("ASCII") : null;
            int n = 9 + byArray.length;
            if (bl) {
                n += byArray2.length + 1;
            }
            IoBuffer ioBuffer = IoBuffer.allocate(n);
            ioBuffer.put(socksProxyRequest.getProtocolVersion());
            ioBuffer.put(socksProxyRequest.getCommandCode());
            ioBuffer.put(socksProxyRequest.getPort());
            ioBuffer.put(socksProxyRequest.getIpAddress());
            ioBuffer.put(byArray);
            ioBuffer.put((byte)0);
            if (bl) {
                ioBuffer.put(byArray2);
                ioBuffer.put((byte)0);
            }
            if (bl) {
                logger.debug("  sending SOCKS4a request");
            } else {
                logger.debug("  sending SOCKS4 request");
            }
            ioBuffer.flip();
            this.writeData(nextFilter, ioBuffer);
        }
        catch (Exception exception) {
            this.closeSession("Unable to send Socks request: ", exception);
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoBuffer ioBuffer) {
        try {
            if (ioBuffer.remaining() >= 8) {
                this.handleResponse(ioBuffer);
            }
        }
        catch (Exception exception) {
            this.closeSession("Proxy handshake failed: ", exception);
        }
    }

    protected void handleResponse(IoBuffer ioBuffer) throws Exception {
        byte by = ioBuffer.get(0);
        if (by != 0) {
            throw new Exception("Socks response seems to be malformed");
        }
        byte by2 = ioBuffer.get(1);
        ioBuffer.position(ioBuffer.position() + 8);
        if (by2 != 90) {
            throw new Exception("Proxy handshake failed - Code: 0x" + ByteUtilities.asHex(new byte[]{by2}) + " (" + SocksProxyConstants.getReplyCodeAsString(by2) + ")");
        }
        this.setHandshakeComplete();
    }
}

