/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.TableState;

public class TableProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof JTable)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    @Override
    public Object getSessionState(Component component) {
        this.checkComponent(component);
        JTable jTable = (JTable)component;
        int[] nArray = new int[jTable.getColumnCount()];
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            int n = nArray[i] = tableColumn.getResizable() ? tableColumn.getWidth() : -1;
            if (!tableColumn.getResizable()) continue;
            bl = true;
        }
        return bl ? new TableState(nArray) : null;
    }

    @Override
    public void setSessionState(Component component, Object object) {
        this.checkComponent(component);
        if (!(object instanceof TableState)) {
            throw new IllegalArgumentException("invalid state");
        }
        JTable jTable = (JTable)component;
        int[] nArray = ((TableState)object).getColumnWidths();
        if (jTable.getColumnCount() == nArray.length) {
            for (int i = 0; i < nArray.length; ++i) {
                TableColumn tableColumn;
                if (nArray[i] == -1 || !(tableColumn = jTable.getColumnModel().getColumn(i)).getResizable()) continue;
                tableColumn.setPreferredWidth(nArray[i]);
            }
        }
    }
}

