/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.utils;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.PNMEncodeParam;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Scanner;
import java.util.logging.Logger;

class GOCR {
    private static final Logger logger = Logger.getLogger(GOCR.class.getName());
    private final BufferedImage image;
    private final String commandLineOptions;
    private static final String PATH_WINDOWS = "tools\\gocr\\gocr.exe";
    private static final String PATH_LINUX = "gocr";

    public GOCR(BufferedImage bufferedImage, String string) {
        this.image = bufferedImage;
        this.commandLineOptions = string;
    }

    public String recognize() throws IOException {
        String string = Utils.isWindows() ? Utils.addFileSeparator(Utils.getAppPath()) + PATH_WINDOWS : PATH_LINUX;
        Scanner scanner = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PNMEncodeParam pNMEncodeParam = new PNMEncodeParam();
            pNMEncodeParam.setRaw(false);
            ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"PNM", (OutputStream)byteArrayOutputStream, (ImageEncodeParam)pNMEncodeParam);
            assert (imageEncoder != null);
            imageEncoder.encode((RenderedImage)this.image);
            Process process = Runtime.getRuntime().exec(string + " " + this.commandLineOptions + " -f ASCII -");
            OutputStream outputStream = process.getOutputStream();
            outputStream.write(byteArrayOutputStream.toByteArray());
            outputStream.close();
            scanner = new Scanner(process.getInputStream());
            StringBuilder stringBuilder = new StringBuilder();
            while (scanner.hasNext()) {
                stringBuilder.append(scanner.next());
            }
            String string2 = stringBuilder.toString();
            if (string2 == null || string2.isEmpty()) {
                throw new IllegalStateException("No output");
            }
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new IOException("Process exited abnormally");
            }
            String string3 = string2;
            return string3;
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            throw new IOException(exception);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception exception) {
                    LogUtils.processException(logger, exception);
                }
            }
        }
    }
}

