/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugimpl;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.dialogs.AccountDialog;
import cz.vity.freerapid.plugins.webclient.hoster.PremiumAccount;
import cz.vity.freerapid.plugins.webclient.interfaces.DialogSupport;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Sound;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdesktop.appframework.swingx.SingleXFrameApplication;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.SingleFrameApplication;

public class StandardDialogSupportImpl
implements DialogSupport {
    private static final Logger logger = Logger.getLogger(StandardDialogSupportImpl.class.getName());
    private volatile String captchaResult;
    private volatile String passwordResult;
    private static final Object captchaLock = new Object();
    private final ApplicationContext context;

    public StandardDialogSupportImpl(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @Override
    public PremiumAccount showAccountDialog(final PremiumAccount premiumAccount, final String string) throws Exception {
        final PremiumAccount[] premiumAccountArray = new PremiumAccount[]{null};
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    StandardDialogSupportImpl.this.getAccount(string, premiumAccount, premiumAccountArray);
                }
            });
        } else {
            this.getAccount(string, premiumAccount, premiumAccountArray);
        }
        return premiumAccountArray[0];
    }

    @Override
    public boolean showOKCancelDialog(final Component component, final String string) throws Exception {
        final boolean[] blArray = new boolean[]{false};
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                blArray[0] = Swinger.showInputDialog(string, component, true) == 0;
            }
        };
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeAndWait(runnable);
        } else {
            runnable.run();
        }
        return blArray[0];
    }

    @Override
    public void showOKDialog(final Component component, final String string) throws Exception {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Swinger.showInputDialog(string, component, false);
                }
            });
        } else {
            Swinger.showInputDialog(string, component, false);
        }
    }

    @Override
    public String askForCaptcha(BufferedImage bufferedImage) throws Exception {
        return this.askForCaptcha(new ImageIcon(bufferedImage));
    }

    private void askCaptcha(Icon icon) {
        if (AppPrefs.getProperty("activateOnCaptcha", true)) {
            Swinger.bringToFront(((SingleFrameApplication)this.context.getApplication()).getMainFrame(), true);
        }
        if (AppPrefs.getProperty("blindMode", false)) {
            Sound.playSound(this.context.getResourceMap().getString("captchaWav", new Object[0]));
        }
        this.captchaResult = (String)JOptionPane.showInputDialog(null, this.context.getResourceMap(DownloadTask.class).getString("InsertWhatYouSee", new Object[0]), this.context.getResourceMap(DownloadTask.class).getString("InsertCaptcha", new Object[0]), -1, icon, null, null);
    }

    private void getAccount(String string, PremiumAccount premiumAccount, PremiumAccount[] premiumAccountArray) {
        SingleXFrameApplication singleXFrameApplication = (SingleXFrameApplication)this.context.getApplication();
        AccountDialog accountDialog = new AccountDialog((Frame)singleXFrameApplication.getMainFrame(), string, premiumAccount);
        try {
            singleXFrameApplication.prepareDialog(accountDialog, true);
        }
        catch (IllegalStateException illegalStateException) {
            LogUtils.processException(logger, illegalStateException);
        }
        premiumAccountArray[0] = accountDialog.getAccount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String askForCaptcha(final Icon icon) throws Exception {
        Object object = captchaLock;
        synchronized (object) {
            this.captchaResult = "";
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        StandardDialogSupportImpl.this.askCaptcha(icon);
                    }
                });
            } else {
                this.askCaptcha(icon);
            }
            if (icon instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)icon;
                imageIcon.getImage().flush();
            }
            return this.captchaResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String askForPassword(final String string) throws Exception {
        Object object = captchaLock;
        synchronized (object) {
            this.passwordResult = "";
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        StandardDialogSupportImpl.this.askPassword(string);
                    }
                });
            } else {
                this.askPassword(string);
            }
            return this.passwordResult;
        }
    }

    private void askPassword(String string) {
        if (AppPrefs.getProperty("activateOnCaptcha", true)) {
            Swinger.bringToFront(((SingleFrameApplication)this.context.getApplication()).getMainFrame(), true);
        }
        this.passwordResult = (String)JOptionPane.showInputDialog(null, this.context.getResourceMap(DownloadTask.class).getString("FileIsPasswordProtected", new Object[]{string}), this.context.getResourceMap(DownloadTask.class).getString("InsertPassword", new Object[0]), -1, null, null, null);
    }
}

