/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.model;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.FileTypeIconProvider;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.plugins.container.FileInfo;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import org.jdesktop.application.AbstractBean;

public class DownloadFile
extends AbstractBean
implements PropertyChangeListener,
HttpFile {
    private static final Logger logger = Logger.getLogger(DownloadFile.class.getName());
    private volatile long fileSize;
    private volatile DownloadTask task = null;
    private volatile DownloadState state = DownloadState.PAUSED;
    private volatile File storeFile;
    private String fileName;
    private volatile long downloaded = 0L;
    private int sleep;
    private float averageSpeed;
    private float shortTimeAvgSpeed;
    private long speed;
    private volatile String errorMessage;
    private volatile URL fileUrl = null;
    private volatile File saveToDirectory;
    private volatile String description;
    private volatile String fileType;
    private volatile int timeToQueued = -1;
    private volatile int timeToQueuedMax = -1;
    private long completeTaskDuration = -1L;
    private volatile int errorAttemptsCount;
    private volatile String shareDownloadServiceID;
    private volatile String serviceName = null;
    private volatile ConnectionSettings connectionSettings;
    private volatile FileState fileState = FileState.NOT_CHECKED;
    private volatile Map<String, Object> properties = new Hashtable<String, Object>();
    private int speedLimit = -1;
    private volatile int tokens;
    private int takenTokens;
    private volatile long realDownload;
    private volatile boolean resumeSupported = true;
    private File storeFileDrive;

    public DownloadFile() {
    }

    public DownloadFile(URL uRL, File file, String string) {
        this.fileUrl = uRL;
        this.saveToDirectory = file;
        this.description = string;
        this.setNewURL(uRL);
    }

    public DownloadFile(FileInfo fileInfo, File file) {
        this.setNewURL(fileInfo.getFileUrl());
        if (fileInfo.getFileName() != null) {
            this.fileName = fileInfo.getFileName();
        }
        this.fileSize = fileInfo.getFileSize();
        this.description = fileInfo.getDescription();
        this.saveToDirectory = file;
    }

    public FileInfo toFileInfo() {
        FileInfo fileInfo = new FileInfo(this.fileUrl);
        fileInfo.setFileName(this.fileName);
        fileInfo.setFileSize(this.fileSize);
        fileInfo.setDescription(this.description);
        return fileInfo;
    }

    @Override
    public void setNewURL(URL uRL) {
        this.setFileUrl(uRL);
        this.fileSize = -1L;
        String string = uRL.toExternalForm();
        this.fileName = FileTypeIconProvider.identifyFileName(string);
        this.resetErrorAttempts();
        this.sleep = -1;
        this.averageSpeed = 0.0f;
        this.speed = 0L;
        this.resumeSupported = true;
        this.fileState = FileState.NOT_CHECKED;
        this.timeToQueued = -1;
        this.setFileType(FileTypeIconProvider.identifyFileType(this.fileName));
    }

    @Override
    public File getSaveToDirectory() {
        return this.saveToDirectory;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setFileSize(long l) {
        long l2 = this.fileSize;
        this.fileSize = l;
        this.firePropertyChange("fileSize", l2, this.fileSize);
    }

    public DownloadTask getTask() {
        return this.task;
    }

    public void setTask(DownloadTask downloadTask) {
        if (downloadTask == null) {
            if (this.task != null) {
                this.task.removePropertyChangeListener(this);
            }
        } else {
            downloadTask.addPropertyChangeListener(this);
        }
        this.task = downloadTask;
    }

    @Override
    public DownloadState getState() {
        return this.state;
    }

    @Override
    public void setState(DownloadState downloadState) {
        if (this.state == DownloadState.DELETED) {
            return;
        }
        DownloadState downloadState2 = this.state;
        this.state = downloadState;
        if (downloadState2 != downloadState) {
            logger.info("Setting state to " + downloadState.toString());
        }
        this.firePropertyChange("state", (Object)downloadState2, (Object)this.state);
    }

    @Override
    public URL getFileUrl() {
        return this.fileUrl;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String string) {
        String string2 = this.fileName;
        this.fileName = string;
        this.setFileType(FileTypeIconProvider.identifyFileType(this.fileName));
        this.firePropertyChange("fileName", string2, this.fileName);
    }

    public String toString() {
        return this.fileUrl.toString();
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public void setDownloaded(long l) {
        long l2 = this.downloaded;
        this.downloaded = l;
        logger.fine("setting downloaded to " + l);
        this.firePropertyChange("downloaded", l2, this.downloaded);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("sleep".equals(propertyChangeEvent.getPropertyName())) {
            this.setSleep((Integer)propertyChangeEvent.getNewValue());
        }
    }

    public void setSpeed(long l) {
        long l2 = this.speed;
        this.speed = l;
        this.firePropertyChange("speed", l2, this.speed);
    }

    public long getSpeed() {
        return this.speed;
    }

    public void setSleep(int n) {
        int n2 = this.sleep;
        this.sleep = n;
        this.firePropertyChange("sleep", n2, this.sleep);
    }

    public void setAverageSpeed(float f) {
        float f2 = this.averageSpeed;
        this.averageSpeed = f;
        this.firePropertyChange("averageSpeed", Float.valueOf(f2), Float.valueOf(this.averageSpeed));
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public int getSleep() {
        return this.sleep;
    }

    public float getAverageSpeed() {
        return this.averageSpeed;
    }

    public String getServiceName() {
        if (this.serviceName == null) {
            return "";
        }
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public File getOutputFile() {
        return new File(this.getSaveToDirectory(), this.fileName);
    }

    public void setFileUrl(URL uRL) {
        this.fileUrl = uRL;
    }

    public void setSaveToDirectory(File file) {
        this.saveToDirectory = file;
        this.storeFileDrive = null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.firePropertyChange("description", string2, this.description);
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        this.fileType = string;
    }

    @Deprecated
    public String getShareDownloadServiceID() {
        return this.shareDownloadServiceID;
    }

    public void setTimeToQueued(int n) {
        int n2 = this.timeToQueued;
        this.timeToQueued = n;
        this.firePropertyChange("timeToQueued", n2, this.timeToQueued);
    }

    public int getTimeToQueued() {
        return this.timeToQueued;
    }

    public void setErrorAttemptsCount(int n) {
        this.errorAttemptsCount = n;
    }

    public int getErrorAttemptsCount() {
        return this.errorAttemptsCount;
    }

    public void resetErrorAttempts() {
        this.errorAttemptsCount = AppPrefs.getProperty("errorAttemptsCount", 5);
    }

    @Deprecated
    public void setShareDownloadServiceID(String string) {
        this.setPluginID(string);
    }

    public int getTimeToQueuedMax() {
        return this.timeToQueuedMax;
    }

    public void setTimeToQueuedMax(int n) {
        this.timeToQueuedMax = n;
    }

    public void resetSpeed() {
        this.setSpeed(0L);
        this.setAverageSpeed(0.0f);
    }

    public long getCompleteTaskDuration() {
        return this.completeTaskDuration;
    }

    public void setCompleteTaskDuration(long l) {
        this.completeTaskDuration = l;
    }

    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public void setConnectionSettings(ConnectionSettings connectionSettings) {
        ConnectionSettings connectionSettings2 = this.connectionSettings;
        this.connectionSettings = connectionSettings;
        this.firePropertyChange("connectionSettings", connectionSettings2, connectionSettings);
    }

    @Override
    public FileState getFileState() {
        return this.fileState;
    }

    @Override
    public void setFileState(FileState fileState) {
        FileState fileState2 = this.fileState;
        this.fileState = fileState;
        this.firePropertyChange("fileState", (Object)fileState2, (Object)fileState);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> map) {
        this.properties = map;
    }

    @Override
    public void setPluginID(String string) {
        this.shareDownloadServiceID = string;
        this.serviceName = this.shareDownloadServiceID.toLowerCase().replace('_', ' ');
    }

    @Override
    public String getPluginID() {
        return this.shareDownloadServiceID;
    }

    public float getShortTimeAvgSpeed() {
        return this.shortTimeAvgSpeed;
    }

    public void setShortTimeAvgSpeed(float f) {
        float f2 = this.shortTimeAvgSpeed;
        this.shortTimeAvgSpeed = f;
        this.firePropertyChange("shortTimeAvgSpeed", Float.valueOf(f2), Float.valueOf(f));
    }

    public int getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(int n) {
        int n2 = this.speedLimit;
        this.speedLimit = n;
        this.firePropertyChange("speedLimit", n2, n);
    }

    public boolean hasSpeedLimit() {
        return this.speedLimit > 0;
    }

    public void setTokensLimit(int n) {
        this.tokens = n;
    }

    public int getTokensLimit() {
        return this.tokens;
    }

    public int getTakenTokens() {
        return this.takenTokens;
    }

    public void setTakenTokens(int n) {
        this.takenTokens = n;
    }

    @Override
    public File getStoreFile() {
        return this.storeFile;
    }

    public File getStoreFileDrive() {
        if (this.storeFileDrive == null) {
            File file = this.getSaveToDirectory();
            if (file != null) {
                this.storeFileDrive = FileUtils.getFileDrive(file);
                return this.storeFileDrive;
            }
            return null;
        }
        return this.storeFileDrive;
    }

    @Override
    public void setStoreFile(File file) {
        this.storeFile = file;
    }

    @Override
    public long getRealDownload() {
        return this.realDownload;
    }

    public void setRealDownload(long l) {
        this.realDownload = l;
    }

    @Override
    public boolean isResumeSupported() {
        return this.resumeSupported;
    }

    @Override
    public void setResumeSupported(boolean bl) {
        boolean bl2 = this.resumeSupported;
        this.resumeSupported = bl;
        this.firePropertyChange("resumeSupported", bl2, this.resumeSupported);
    }

    static {
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            BeanInfo beanInfo = Introspector.getBeanInfo(DownloadFile.class);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                String string = propertyDescriptor.getName();
                if (!"task".equals(string) && !"speed".equals(string) && !"shortTimeAvgSpeed".equals(string) && !"connectionSettings".equals(string) && !"tokens".equals(string) && !"takenTokens".equals(string) && !"storeFileDrive".equals(string)) continue;
                propertyDescriptor.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException introspectionException) {
            LogUtils.processException(logger, introspectionException);
        }
    }
}

