/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CheckPluginUpdateTask;
import cz.vity.freerapid.core.tasks.DownloadNewPluginsTask;
import cz.vity.freerapid.gui.dialogs.UpdateDialog;
import cz.vity.freerapid.gui.dialogs.WrappedPluginData;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.xmlimport.ver1.Plugin;
import java.awt.Frame;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.java.plugin.registry.Version;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;

public class UpdateManager {
    private static final Logger logger = Logger.getLogger(UpdateManager.class.getName());
    private final ManagerDirector director;
    private final ApplicationContext context;
    private Timer timer;

    public UpdateManager(ManagerDirector managerDirector, ApplicationContext applicationContext) {
        this.director = managerDirector;
        this.context = applicationContext;
        if (AppPrefs.getProperty("blindMode", false)) {
            AppPrefs.storeProperty("pluginUpdateMethod", 2);
        }
        this.initListeners();
        this.initUpdateTimer();
    }

    private void initListeners() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                String string = preferenceChangeEvent.getKey();
                if ("pluginUpdateCheckInterval".equals(string) || "pluginLastUpdateDateTime".equals(string)) {
                    UpdateManager.this.initUpdateTimer();
                }
            }
        });
    }

    private void initUpdateTimer() {
        Calendar calendar;
        int n = Math.max(AppPrefs.getProperty("pluginUpdateCheckInterval", 24), 4);
        long l = AppPrefs.getProperty("pluginLastUpdateDateTime", 0L);
        Calendar calendar2 = Calendar.getInstance();
        if (l < 0L) {
            calendar2.add(11, 1);
            calendar = calendar2;
        } else {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l);
            calendar.add(11, n);
            if (l == 0L || calendar2.after(calendar)) {
                calendar2.add(13, 17);
                calendar = calendar2;
            }
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer("UpdateTimer");
        logger.info(String.format("Rescheduling plugins update check to %1$ta %1$tb %1$td %1$tT", calendar.getTime()));
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (UpdateManager.this.checkForUpdates()) {
                    UpdateManager.this.checkUpdate(true);
                }
            }
        }, calendar.getTime(), (long)(n * 1000) * 3600L);
    }

    private boolean checkForUpdates() {
        return AppPrefs.getProperty("check4PluginUpdatesAutomatically", true);
    }

    public void checkUpdate(final boolean bl) {
        CheckPluginUpdateTask checkPluginUpdateTask = new CheckPluginUpdateTask(this.director, this.context, bl);
        checkPluginUpdateTask.addTaskListener((TaskListener)new TaskListener.Adapter<List<Plugin>, Void>(){

            public void succeeded(final TaskEvent<List<Plugin>> taskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpdateManager.this.updateDetected((List)taskEvent.getValue(), bl);
                    }
                });
            }
        });
        this.context.getTaskService().execute((Task)checkPluginUpdateTask);
    }

    private void updateDetected(List<Plugin> list, boolean bl) {
        int n = !bl ? 1 : AppPrefs.getProperty("pluginUpdateMethod", 0);
        List<WrappedPluginData> list2 = n == 2 || n == 3 ? this.generateUpdateData(list, false) : this.generateUpdateData(list, true);
        if (list2.isEmpty()) {
            if (!bl) {
                Swinger.showInformationDialog(this.context.getResourceMap().getString("updatesNotFoundMessage", new Object[0]));
            }
            return;
        }
        if (n == 0) {
            int n2 = Swinger.showOptionDialog(this.context.getResourceMap(), 3, "informationMessage", "updatesFoundMessage", new String[]{"updateWithDetails", "updateNowButton", "updateCancel"}, new Object[0]);
            n = n2 == 0 ? 1 : (n2 == 1 ? 2 : -1);
        }
        switch (n) {
            case 1: {
                this.showUpdateDialog(list2, false);
                break;
            }
            case 2: {
                this.showUpdateDialog(list2, true);
                break;
            }
            case 3: {
                this.downloadUpdate(list2, bl);
                break;
            }
        }
    }

    private void showUpdateDialog(List<WrappedPluginData> list, boolean bl) {
        final UpdateDialog updateDialog = new UpdateDialog((Frame)this.director.getMainFrame(), this.director);
        updateDialog.initData(list);
        MainApp mainApp = (MainApp)this.context.getApplication();
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    updateDialog.okBtnAction();
                }
            });
        }
        mainApp.prepareDialog(updateDialog, true);
    }

    private void downloadUpdate(List<WrappedPluginData> list, boolean bl) {
        Task task = this.getDownloadPluginsTask(list, bl);
        if (task != null) {
            this.executeUpdateTask(task);
        }
    }

    public DownloadFile getDownloadFileInstance(Plugin plugin) throws MalformedURLException {
        DownloadFile downloadFile = new DownloadFile();
        downloadFile.setFileUrl(new URL(plugin.getUrl()));
        downloadFile.setFileName(plugin.getFilename());
        downloadFile.setState(DownloadState.PAUSED);
        downloadFile.setErrorAttemptsCount(0);
        downloadFile.setFileSize(plugin.getFilesize());
        return downloadFile;
    }

    public Task getDownloadPluginsTask(List<WrappedPluginData> list, boolean bl) {
        LinkedList<WrappedPluginData> linkedList = new LinkedList<WrappedPluginData>();
        for (WrappedPluginData wrappedPluginData : list) {
            DownloadFile downloadFile;
            if (!wrappedPluginData.isSelected() || (downloadFile = wrappedPluginData.getHttpFile()).getState() == DownloadState.COMPLETED) continue;
            linkedList.add(wrappedPluginData);
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        return new DownloadNewPluginsTask(this.director, this.context, linkedList, bl);
    }

    public void executeUpdateTask(Task task) {
        this.context.getTaskService().execute(task);
    }

    private List<WrappedPluginData> generateUpdateData(List<Plugin> list, boolean bl) {
        Object bl3;
        Object object;
        PluginsManager pluginsManager = this.director.getPluginsManager();
        boolean bl2 = AppPrefs.getProperty("downloadNotExistingPlugins", true);
        LinkedList<WrappedPluginData> linkedList = new LinkedList<WrappedPluginData>();
        HashSet<String> hashSet = new HashSet<String>(list.size());
        for (Plugin object5 : list) {
            boolean bl4;
            boolean plugin;
            String string = object5.getId();
            hashSet.add(string);
            Object object2 = Version.parse((String)object5.getVersion());
            object5.setVersion(object2.toString());
            boolean bl5 = plugin = !pluginsManager.hasPlugin(string);
            if (!plugin) {
                object = Version.parse((String)pluginsManager.getPluginMetadata(string).getVersion());
                logger.info("id = " + (String)string + "  oldVersion = " + object + "  newVersion = " + object2);
                if (object2.equals(object)) continue;
                bl3 = pluginsManager.getPluginMetadata(string);
                logger.info("found new plugin with id =" + (String)string);
                if (!((PluginMetaData)bl3).isUpdatesEnabled()) {
                    logger.info("It's disabled to download new plugins, ignoring " + (String)string);
                    continue;
                }
            }
            boolean bl6 = bl4 = bl2 || !plugin;
            if (!bl4 && !bl) continue;
            try {
                object = this.getDownloadFileInstance(object5);
                WrappedPluginData malformedURLException = new WrappedPluginData(bl4, (DownloadFile)object, object5);
                malformedURLException.setNew(plugin);
                if (!plugin) {
                    malformedURLException.setPluginInUse(pluginsManager.isPluginInUseForUpdates(string));
                }
                linkedList.add(malformedURLException);
            }
            catch (MalformedURLException malformedURLException) {
                LogUtils.processException(logger, malformedURLException);
            }
        }
        boolean bl7 = AppPrefs.getProperty("removeNotSupportedPlugins", false);
        if (bl7) {
            List<PluginMetaData> list2 = pluginsManager.getSupportedPlugins();
            for (Object object2 : list2) {
                if (hashSet.contains(((PluginMetaData)object2).getId())) continue;
                Plugin plugin = new Plugin();
                plugin.setId(((PluginMetaData)object2).getId());
                plugin.setVersion(((PluginMetaData)object2).getVersion());
                plugin.setVendor(((PluginMetaData)object2).getVendor());
                plugin.setServices(((PluginMetaData)object2).getServices());
                plugin.setUrl(((PluginMetaData)object2).getWWW());
                plugin.setFilename("xxxx.frp");
                plugin.setFilesize(0L);
                plugin.setPremium(String.valueOf(((PluginMetaData)object2).isPremium()));
                object = new DownloadFile();
                ((DownloadFile)object).setState(DownloadState.QUEUED);
                bl3 = new WrappedPluginData(true, (DownloadFile)object, plugin);
                ((WrappedPluginData)bl3).setToBeDeleted(true);
                linkedList.add((WrappedPluginData)bl3);
            }
        }
        return linkedList;
    }

    private static String getUniqueId(String string, String string2) {
        return string + '@' + string2;
    }
}

