/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.SearchField;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.search.SearchItem;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.ToolbarSeparator;
import cz.vity.freerapid.swing.binding.BindUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.ApplicationContext;

public class ToolbarManager
implements PropertyChangeListener {
    private final JPanel toolbarPanel = new JPanel(new BorderLayout());
    private static final Dimension buttonDimensionWithText = new Dimension(74, 68);
    private static final Dimension buttonWithoutWithoutTextDimension = new Dimension(40, 38);
    private JToolBar toolbar = new JToolBar("mainToolbar");
    private float fontSize;
    private SearchField searchField;
    private final ManagerDirector directorManager;
    private final ApplicationContext context;

    public ToolbarManager(ManagerDirector managerDirector, ApplicationContext applicationContext) {
        this.directorManager = managerDirector;
        this.context = applicationContext;
        this.toolbarPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        Action action = applicationContext.getActionMap().get((Object)"showToolbar");
        ValueModel valueModel = BindUtils.getPrefsValueModel("showToolbar", true);
        action.putValue("SwingSelectedKey", valueModel.getValue());
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)this.toolbarPanel, (String)"visible");
        this.fontSize = applicationContext.getResourceMap().getFloat("buttonBarFontSize").floatValue();
        this.createToolbar();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("done".equals(string) || "started".equals(string)) {
            // empty if block
        }
    }

    private void createToolbar() {
        this.toolbarPanel.add(this.toolbar);
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        Border border = this.toolbar.getBorder();
        Border border2 = BorderFactory.createEmptyBorder(2, 2, 1, 2);
        if (border != null) {
            this.toolbar.setBorder(BorderFactory.createCompoundBorder(border, border2));
        } else {
            this.toolbar.setBorder(border2);
        }
        this.toolbar.add(this.getButton(Swinger.getAction("addNewLinksAction")));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(this.getButton(Swinger.getAction("resumeAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("pauseAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("cancelAction")));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(this.getButton(Swinger.getAction("topAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("upAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("downAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("bottomAction")));
        this.toolbar.add(Box.createGlue());
        this.searchField = new SearchField(this.context);
        this.searchField.setSearchItemList(this.directorManager.getSearchManager().getSearchItems());
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SearchItem searchItem;
                if (keyEvent.getKeyCode() == 10 && (searchItem = ToolbarManager.this.searchField.getSelectedItem()) != null) {
                    ToolbarManager.this.directorManager.getSearchManager().openBrowser(searchItem, ToolbarManager.this.searchField.getText());
                    Swinger.inputFocus(ToolbarManager.this.searchField);
                }
            }
        });
        ValueModel valueModel = BindUtils.getPrefsValueModel("searchFieldText", "");
        Bindings.bind((JTextField)this.searchField, (ValueModel)valueModel, (boolean)false);
        valueModel = BindUtils.getPrefsValueModel("searchFieldVisible", true);
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)this.searchField, (String)"visible");
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (ToolbarManager.this.directorManager.getSearchManager().checkForDirChange()) {
                    ToolbarManager.this.directorManager.getSearchManager().loadSearchData();
                    ToolbarManager.this.searchField.setSearchItemList(ToolbarManager.this.directorManager.getSearchManager().getSearchItems());
                }
            }
        });
        this.toolbar.add(this.searchField);
        this.toolbar.add(Box.createHorizontalStrut(3));
        AbstractButton abstractButton = this.getButton(Swinger.getAction("paypalSupportAction"));
        abstractButton.putClientProperty("noChange", true);
        abstractButton.setOpaque(false);
        abstractButton.setRolloverEnabled(false);
        abstractButton.setBackground(null);
        abstractButton.setText(null);
        abstractButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPrefs.getProperty("showPaypal", true)) {
            this.toolbar.add(abstractButton);
        }
        this.toolbar.add(Box.createHorizontalStrut(18));
        this.updateButtons(AppPrefs.getProperty("showButtonTextToolbar", true));
        this.checkPreferences();
    }

    private void checkPreferences() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(final PreferenceChangeEvent preferenceChangeEvent) {
                if ("showButtonTextToolbar".equals(preferenceChangeEvent.getKey())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ToolbarManager.this.updateButtons(Boolean.valueOf(preferenceChangeEvent.getNewValue()));
                        }
                    });
                }
            }
        });
    }

    private void updateButtons(boolean bl) {
        Dimension dimension;
        Component[] componentArray = this.toolbar.getComponents();
        if (bl) {
            this.toolbarPanel.setPreferredSize(new Dimension(400, 54));
            dimension = buttonDimensionWithText;
        } else {
            dimension = buttonWithoutWithoutTextDimension;
            this.toolbarPanel.setPreferredSize(new Dimension(400, 47));
        }
        for (Component component : componentArray) {
            AbstractButton abstractButton;
            if (!(component instanceof AbstractButton) || (abstractButton = (AbstractButton)component).getClientProperty("noChange") != null) continue;
            abstractButton.setMinimumSize(dimension);
            abstractButton.setPreferredSize(dimension);
            abstractButton.setMaximumSize(dimension);
            if (bl) {
                this.updateButtonText(abstractButton, abstractButton.getAction());
                continue;
            }
            abstractButton.setText(null);
        }
        this.toolbar.getParent().validate();
        this.toolbar.getParent().repaint();
    }

    private void setToolBarVisible(boolean bl) {
        this.toolbarPanel.setVisible(bl);
    }

    public JComponent getComponent() {
        return this.toolbarPanel;
    }

    private AbstractButton getToggleButton(Action action) {
        JToggleButton jToggleButton = new JToggleButton(action);
        return this.setButtonProperties(jToggleButton, action);
    }

    private AbstractButton getButton(Action action) {
        JButton jButton = new JButton(action);
        return this.setButtonProperties(jButton, action);
    }

    private AbstractButton setButtonProperties(AbstractButton abstractButton, Action action) {
        abstractButton.setRolloverEnabled(true);
        abstractButton.setIconTextGap(0);
        Object object = action.getValue("ShortDescription");
        Font font = abstractButton.getFont();
        abstractButton.setFont(font.deriveFont(this.fontSize));
        abstractButton.setVerticalTextPosition(3);
        abstractButton.setHorizontalTextPosition(0);
        abstractButton.setText(null);
        Object object2 = action.getValue("AcceleratorKey");
        if (object != null && object2 != null) {
            abstractButton.setToolTipText(object.toString() + " (" + SwingUtils.keyStroke2String((KeyStroke)object2) + ")");
        }
        abstractButton.setMnemonic(0);
        abstractButton.setFocusable(false);
        return abstractButton;
    }

    private void updateButtonText(AbstractButton abstractButton, Action action) {
        String string = (String)action.getValue("Name");
        if (string != null && string.endsWith("...")) {
            string = string.substring(0, string.length() - 3);
        }
        abstractButton.setText(string);
    }

    public SearchField getSearchField() {
        return this.searchField;
    }
}

