/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.search.OpenSearchDescription;
import cz.vity.freerapid.gui.managers.search.OpenSearchDescriptionBinding;
import cz.vity.freerapid.gui.managers.search.SearchItem;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import jlibs.xml.sax.binding.BindingHandler;
import org.jdesktop.application.ApplicationContext;
import org.xml.sax.InputSource;

public class SearchManager {
    private static final String SEARCH_DIR = "search";
    private static final Logger logger = Logger.getLogger(SearchManager.class.getName());
    private List<SearchItem> searchItems;
    private int filesCount = -1;
    private long lastModified = -1L;

    public SearchManager(ApplicationContext applicationContext, ManagerDirector managerDirector) {
    }

    public void loadSearchData() {
        File file = this.getDirectory();
        if (file == null) {
            this.searchItems = Collections.emptyList();
            return;
        }
        Object[] objectArray = this.getFiles(file);
        this.searchItems = new ArrayList<SearchItem>(objectArray.length);
        this.filesCount = -1;
        this.lastModified = -1L;
        this.filesCount = objectArray.length;
        Arrays.sort(objectArray);
        BindingHandler bindingHandler = new BindingHandler(OpenSearchDescriptionBinding.class);
        bindingHandler.setPopulateNamespaces(true);
        for (Object object : objectArray) {
            long l = ((File)object).lastModified();
            if (l > this.lastModified) {
                this.lastModified = l;
            }
            logger.info("Parsing search.xml file " + ((File)object).getAbsolutePath());
            try {
                OpenSearchDescription openSearchDescription = (OpenSearchDescription)bindingHandler.parse(new InputSource(new FileInputStream((File)object)));
                if (openSearchDescription == null) {
                    logger.warning("Ignoring file - this is not OpenSearchDescription file! " + ((File)object).getAbsolutePath());
                    continue;
                }
                if (openSearchDescription.getUrlTemplate() == null || openSearchDescription.getShortName() == null) {
                    logger.warning("Invalid search description " + openSearchDescription);
                    continue;
                }
                this.searchItems.add(new SearchItem(((File)object).getName(), openSearchDescription));
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
        }
    }

    private File getDirectory() {
        File file = new File(Utils.getAppPath(), SEARCH_DIR);
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        return file;
    }

    public boolean checkForDirChange() {
        File file = this.getDirectory();
        if (file == null) {
            return false;
        }
        File[] fileArray = this.getFiles(file);
        if (fileArray.length != this.filesCount) {
            return true;
        }
        for (File file2 : fileArray) {
            if (file2.lastModified() <= this.lastModified) continue;
            return true;
        }
        return false;
    }

    private File[] getFiles(File file) {
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase(Locale.ENGLISH).endsWith(".xml");
            }
        });
    }

    public void openBrowser(SearchItem searchItem, String string) {
        Serializable serializable;
        OpenSearchDescription openSearchDescription = searchItem.getSearchDescription();
        String string2 = openSearchDescription.getInputEncoding();
        String string3 = openSearchDescription.getUrlTemplate();
        string3 = this.replaceSearchedText(string, string2, string3);
        Map<String, String> map = openSearchDescription.getUrlParams();
        if (!map.isEmpty()) {
            serializable = new StringBuilder(string3);
            if (!string3.contains("?")) {
                ((StringBuilder)serializable).append('?');
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                char c = ((StringBuilder)serializable).charAt(((StringBuilder)serializable).length() - 1);
                if (c != '&' && c != '?' && c != '/') {
                    ((StringBuilder)serializable).append('&');
                }
                ((StringBuilder)serializable).append(entry.getKey()).append('=');
                if (entry.getValue().contains("{searchTerms}")) {
                    ((StringBuilder)serializable).append(this.replaceSearchedText(string, string2, entry.getValue()));
                    continue;
                }
                ((StringBuilder)serializable).append(entry.getValue());
            }
            string3 = ((StringBuilder)serializable).toString();
        }
        try {
            serializable = new URI(string3).toURL();
            logger.info("Opening URL " + ((URL)serializable).toExternalForm());
            Browser.openBrowser((URL)serializable);
        }
        catch (MalformedURLException malformedURLException) {
            logger.severe("Error generating URL:" + string3 + " " + malformedURLException.getMessage());
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.severe("Error generating URL:" + string3 + " " + uRISyntaxException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.severe("Error generating URL:" + string3 + " " + illegalArgumentException.getMessage());
        }
    }

    private String replaceSearchedText(String string, String string2, String string3) {
        return string3.replace("{searchTerms}", this.encode(string, string2));
    }

    private String encode(String string, String string2) {
        String string3;
        try {
            string3 = URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
        return string3;
    }

    public List<SearchItem> getSearchItems() {
        return this.searchItems;
    }
}

