/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.list.ArrayListModel;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.swing.SwingXUtils;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.swingx.hyperlink.LinkModel;

class PluginMetaDataTableModel
extends AbstractTableModel
implements ListDataListener {
    private final ArrayListModel<PluginMetaData> model;
    private final String[] columns;
    static final int COLUMN_ACTIVE = 0;
    static final int COLUMN_UPDATE = 1;
    static final int COLUMN_CLIPBOARD_MONITORED = 2;
    static final int COLUMN_ID = 3;
    static final int COLUMN_VERSION = 4;
    static final int COLUMN_SERVICES = 5;
    static final int COLUMN_AUTHOR = 6;
    static final int COLUMN_MAX_PARALEL_DOWNLOADS = 7;
    static final int COLUMN_PRIORITY = 8;
    static final int COLUMN_WWW = 9;

    public PluginMetaDataTableModel(ArrayListModel<PluginMetaData> arrayListModel, String[] stringArray) {
        this.model = arrayListModel;
        this.columns = stringArray;
        arrayListModel.addListDataListener((ListDataListener)this);
    }

    @Override
    public int getRowCount() {
        return this.model.getSize();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 || n2 == 1 || n2 == 8 || n2 == 7 || n2 == 2;
    }

    @Override
    public String getColumnName(int n) {
        return this.columns[n];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0 || n == 1 || n == 2) {
            return Boolean.class;
        }
        if (n == 8 || n == 7) {
            return Integer.class;
        }
        if (n == 9) {
            return LinkModel.class;
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PluginMetaData pluginMetaData = (PluginMetaData)this.model.get(n);
        switch (n2) {
            case 0: {
                return pluginMetaData.isEnabled();
            }
            case 1: {
                return pluginMetaData.isUpdatesEnabled();
            }
            case 2: {
                return pluginMetaData.isClipboardMonitored();
            }
            case 3: {
                return pluginMetaData.getId();
            }
            case 4: {
                return pluginMetaData.getVersion();
            }
            case 5: {
                return pluginMetaData.getServices();
            }
            case 6: {
                return pluginMetaData.getVendor();
            }
            case 7: {
                return pluginMetaData.getMaxAllowedDownloads();
            }
            case 8: {
                return pluginMetaData.getPluginPriority();
            }
            case 9: {
                return SwingXUtils.createLink(pluginMetaData.getWWW());
            }
        }
        assert (false);
        return pluginMetaData;
    }

    public PluginMetaData getObject(int n) {
        return (PluginMetaData)this.model.get(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        PluginMetaData pluginMetaData = (PluginMetaData)this.model.get(n);
        if (n2 == 0) {
            pluginMetaData.setEnabled((Boolean)object);
        } else if (n2 == 1) {
            pluginMetaData.setUpdatesEnabled((Boolean)object);
        } else if (n2 == 8) {
            pluginMetaData.setPluginPriority((Integer)object);
        } else if (n2 == 7) {
            pluginMetaData.setMaxAllowedDownloads((Integer)object);
        } else if (n2 == 2) {
            pluginMetaData.setClipboardMonitored((Boolean)object);
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireTableRowsInserted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireTableRowsDeleted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireTableRowsUpdated(listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }

    public PluginMetaData getMetaValueAt(int n) {
        return (PluginMetaData)this.model.get(n);
    }
}

