/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.util.EnumSet;

public final class DownloadsActions {
    private static final int[] priorities = new int[DownloadState.values().length];
    public static EnumSet<DownloadState> pauseEnabledStates;
    public static EnumSet<DownloadState> resumeEnabledStates;
    public static EnumSet<DownloadState> cancelEnabledStates;
    public static EnumSet<DownloadState> forceEnabledStates;
    public static EnumSet<DownloadState> recheckExistingStates;
    public static EnumSet<DownloadState> completedStates;

    private DownloadsActions() {
    }

    public static boolean isProcessState(DownloadState downloadState) {
        return downloadState == DownloadState.WAITING || downloadState == DownloadState.DOWNLOADING || downloadState == DownloadState.GETTING || downloadState == DownloadState.TESTING;
    }

    public static int getPriorityForState(DownloadState downloadState) {
        return priorities[downloadState.ordinal()];
    }

    static {
        DownloadsActions.priorities[DownloadState.DOWNLOADING.ordinal()] = 0;
        DownloadsActions.priorities[DownloadState.GETTING.ordinal()] = 10;
        DownloadsActions.priorities[DownloadState.TESTING.ordinal()] = 20;
        DownloadsActions.priorities[DownloadState.WAITING.ordinal()] = 30;
        DownloadsActions.priorities[DownloadState.QUEUED.ordinal()] = 40;
        DownloadsActions.priorities[DownloadState.SLEEPING.ordinal()] = 50;
        DownloadsActions.priorities[DownloadState.ERROR.ordinal()] = 60;
        DownloadsActions.priorities[DownloadState.HOLD_ON.ordinal()] = 70;
        DownloadsActions.priorities[DownloadState.PAUSED.ordinal()] = 80;
        DownloadsActions.priorities[DownloadState.DISABLED.ordinal()] = 90;
        DownloadsActions.priorities[DownloadState.SKIPPED.ordinal()] = 100;
        DownloadsActions.priorities[DownloadState.CANCELLED.ordinal()] = 110;
        DownloadsActions.priorities[DownloadState.COMPLETED.ordinal()] = 120;
        DownloadsActions.priorities[DownloadState.DELETED.ordinal()] = 1000;
        pauseEnabledStates = EnumSet.of(DownloadState.ERROR, new DownloadState[]{DownloadState.SLEEPING, DownloadState.GETTING, DownloadState.QUEUED, DownloadState.WAITING, DownloadState.DISABLED, DownloadState.TESTING});
        resumeEnabledStates = EnumSet.of(DownloadState.ERROR, new DownloadState[]{DownloadState.SLEEPING, DownloadState.CANCELLED, DownloadState.SKIPPED, DownloadState.HOLD_ON, DownloadState.PAUSED, DownloadState.DISABLED});
        cancelEnabledStates = EnumSet.of(DownloadState.COMPLETED, new DownloadState[]{DownloadState.ERROR, DownloadState.SLEEPING, DownloadState.DOWNLOADING, DownloadState.GETTING, DownloadState.WAITING, DownloadState.HOLD_ON, DownloadState.PAUSED, DownloadState.DISABLED, DownloadState.TESTING, DownloadState.SKIPPED});
        forceEnabledStates = EnumSet.of(DownloadState.ERROR, new DownloadState[]{DownloadState.SLEEPING, DownloadState.QUEUED, DownloadState.HOLD_ON, DownloadState.PAUSED, DownloadState.CANCELLED, DownloadState.SKIPPED, DownloadState.DISABLED});
        recheckExistingStates = EnumSet.of(DownloadState.ERROR, new DownloadState[]{DownloadState.QUEUED, DownloadState.HOLD_ON, DownloadState.PAUSED, DownloadState.CANCELLED, DownloadState.SKIPPED, DownloadState.DISABLED});
        completedStates = EnumSet.of(DownloadState.COMPLETED);
    }
}

