/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.AbstractValueModel;
import java.util.prefs.Preferences;

public final class PreferencesAdapter
extends AbstractValueModel {
    private static final String ERROR_MSG = "Value must be a Boolean, Double, Float, Integer, Long, or String.";
    private final Preferences prefs;
    private final String key;
    private final Class<?> type;
    private final Object defaultValue;

    public PreferencesAdapter(Preferences prefs, String key, Object defaultValue) {
        if (prefs == null) {
            throw new NullPointerException("The Preferences must not be null.");
        }
        if (key == null) {
            throw new NullPointerException("The key must not be null.");
        }
        if (defaultValue == null) {
            throw new NullPointerException("The default value must not be null.");
        }
        if (!this.isBackedType(defaultValue)) {
            throw new IllegalArgumentException("The Default Value must be a Boolean, Double, Float, Integer, Long, or String.");
        }
        this.prefs = prefs;
        this.key = key;
        this.type = defaultValue.getClass();
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getValue() {
        if (this.type == Boolean.class) {
            return this.getBoolean();
        }
        if (this.type == Double.class) {
            return this.getDouble();
        }
        if (this.type == Float.class) {
            return Float.valueOf(this.getFloat());
        }
        if (this.type == Integer.class) {
            return this.getInt();
        }
        if (this.type == Long.class) {
            return this.getLong();
        }
        if (this.type == String.class) {
            return this.getString();
        }
        throw new ClassCastException(ERROR_MSG);
    }

    @Override
    public void setValue(Object newValue) {
        if (newValue == null) {
            throw new NullPointerException("The value must not be null.");
        }
        if (newValue instanceof Boolean) {
            this.setBoolean((Boolean)newValue);
        } else if (newValue instanceof Double) {
            this.setDouble((Double)newValue);
        } else if (newValue instanceof Float) {
            this.setFloat(((Float)newValue).floatValue());
        } else if (newValue instanceof Integer) {
            this.setInt((Integer)newValue);
        } else if (newValue instanceof Long) {
            this.setLong((Long)newValue);
        } else if (newValue instanceof String) {
            this.setString((String)newValue);
        }
    }

    public boolean getBoolean() {
        return this.prefs.getBoolean(this.key, (Boolean)this.defaultValue);
    }

    public double getDouble() {
        return this.prefs.getDouble(this.key, (Double)this.defaultValue);
    }

    public float getFloat() {
        return this.prefs.getFloat(this.key, ((Float)this.defaultValue).floatValue());
    }

    public int getInt() {
        return this.prefs.getInt(this.key, (Integer)this.defaultValue);
    }

    public long getLong() {
        return this.prefs.getLong(this.key, (Long)this.defaultValue);
    }

    @Override
    public String getString() {
        return this.prefs.get(this.key, (String)this.defaultValue);
    }

    public void setBoolean(boolean newValue) {
        boolean oldValue = this.getBoolean();
        this.prefs.putBoolean(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    public void setDouble(double newValue) {
        double oldValue = this.getDouble();
        this.prefs.putDouble(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    public void setFloat(float newValue) {
        float oldValue = this.getFloat();
        this.prefs.putFloat(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    public void setInt(int newValue) {
        int oldValue = this.getInt();
        this.prefs.putInt(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    public void setLong(long newValue) {
        long oldValue = this.getLong();
        this.prefs.putLong(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    public void setString(String newValue) {
        String oldValue = this.getString();
        this.prefs.put(this.key, newValue);
        this.fireValueChange(oldValue, newValue);
    }

    private boolean isBackedType(Object value) {
        Class<?> aClass = value.getClass();
        return aClass == Boolean.class || aClass == Double.class || aClass == Float.class || aClass == Integer.class || aClass == Long.class || aClass == String.class;
    }
}

