// 
//  Copyright © 2009 Jiří Zárevúcky <zarevucky.jiri@gmail.com>
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Affero General Public License as
//  published by the Free Software Foundation, either version 3 of the
//  License, or (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Affero General Public License for more details.
// 
//  You should have received a copy of the GNU Affero General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 
// 


using System;

using Galaxium.Protocol.Xmpp.Library;
using Galaxium.Protocol.Xmpp.Library.Utility;
using Galaxium.Protocol.Xmpp.Library.Core;
using Galaxium.Protocol.Xmpp.Library.Xml;

namespace Galaxium.Protocol.Xmpp.Library.Sasl
{
	// SASL mechanism base class
	public abstract class Mechanism
	{
		private Func<Element, Element> _send;
		
		public Mechanism (Func<Element, Element> method)
		{
			_send = method;
		}

		protected Element Send (Element elm)
		{
			return _send (elm);
		}
		
		protected static Element GenerateAuth (string mechanism, string text)
		{
			return new Element (null, "auth", Namespaces.Sasl, "mechanism", mechanism).SetText (text);
		}
		
		protected static string GenerateNonce ()
		{
			return Cryptography.Md5HexHash (new Random ().Next ().ToString ());
		}
		
		public abstract void Auth (JabberID jid, string password);
	}
}
