/*
 * Galaxium Messenger
 * Copyright (C) 2008 Ben Motmans <ben.motmans@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

using Mono.Addins;

using Anculus.Core;

namespace Galaxium.Client
{
	/// <summary>
	/// Extension used to describe platforms found by the addin utility.
	/// </summary>
	public class PlatformExtension : TypeExtensionNode
	{
		public IPlatform Platform
		{
			get
			{
				try
				{
					IPlatform platform = (IPlatform)base.CreateInstance ();
					
					return platform;
				}
				catch (Exception e)
				{
					Log.Error (e, "Unable to create platform instance.");
					
					return null;
				}
			}
		}
	}
}
