# -*- coding: utf-8 -*-

#   This file is part of emesene.
#
#    Emesene is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    emesene is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with emesene; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from emesenelib import soap, common

def membership(proxy, callback, sync):
    common.debug("soap.requests: membership list", "soap")
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/FindMembership',
        'contacts.msn.com', 443, '/abservice/SharingService.asmx',
        soap.templates.membershipList, callback, sync=sync)

def address_book(proxy, callback, sync):
    common.debug("soap.requests: address book", "soap")
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/ABFindAll',
        'contacts.msn.com', 443, '/abservice/abservice.asmx',
        soap.templates.addressBook, callback, sync=sync)

def dynamic_items(proxy, callback, sync):
    common.debug("soap.requests: dynamic items", "soap")
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/ABFindAll',
        'contacts.msn.com', 443, '/abservice/abservice.asmx',
        soap.templates.dynamicItems, callback, sync=sync)

def schematized_store(proxy, email, callback, *args):
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/storage/w10/GetItemVersion',
        'storage.msn.com', 80, '/storageservice/schematizedstore.asmx',
        soap.templates.schematizedStore%(email), callback, args)

def change_nick(proxy, nick, callback, *args):
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/ABContactUpdate',
        'omega.contacts.msn.com', 443, '/abservice/abservice.asmx',
        soap.templates.changeNick % ('Me', common.escape(nick)),
        callback, args)

def change_alias(proxy, contactID, alias, callback, *args):
    alias = str(common.escape(alias))
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/ABContactUpdate',
        'omega.contacts.msn.com', 443, '/abservice/abservice.asmx',
        soap.templates.renameContact % (str(contactID), alias),
        callback, args)

def add_contact(proxy, email, callback, *args):
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/ABContactAdd',
        'omega.contacts.msn.com', 443, '/abservice/abservice.asmx',
        soap.templates.contactAdd % (email, ), callback, args)

def remove_contact(proxy, contactID, callback, *args):
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/ABContactDelete',
        'omega.contacts.msn.com', 443, '/abservice/abservice.asmx',
        soap.templates.contactRemove % (contactID, ), callback, args)

def add_to_group(proxy, gid, contactID, callback, *args):
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/ABGroupContactAdd',
        'omega.contacts.msn.com', 443, '/abservice/abservice.asmx',
        soap.templates.moveUserToGroup % (gid, contactID), callback, args)

def remove_from_group(proxy, contactID, sourceGid, callback, *args):
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/ABGroupContactDelete',
        'omega.contacts.msn.com', 443, '/abservice/abservice.asmx',
        soap.templates.deleteUserFromGroup % (contactID, sourceGid),
        callback, args)

def add_role(proxy, role, email, callback, *args):
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/AddMember',
        'omega.contacts.msn.com', 443, '/abservice/SharingService.asmx',
        soap.templates.addMember % (role, email), callback, args)

def delete_role(proxy, role, email, callback, *args):
    soap.manager.do_request(proxy,
        'http://www.msn.com/webservices/AddressBook/DeleteMember',
        'omega.contacts.msn.com', 443, '/abservice/SharingService.asmx',
        soap.templates.deleteMember % (role, email), callback, args)

