/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.RenderingHints;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalTheme;

public abstract class AbstractTheme
extends MetalTheme {
    public static final int TEXT_ANTIALIAS_DEFAULT = 0;
    public static final int TEXT_ANTIALIAS_GRAY = 1;
    public static final int TEXT_ANTIALIAS_HRGB = 2;
    public static final int TEXT_ANTIALIAS_HBGR = 3;
    public static final int TEXT_ANTIALIAS_VRGB = 4;
    public static final int TEXT_ANTIALIAS_VBGR = 5;
    public static final String DIALOG = "Dialog";
    public static final ColorUIResource red = new ColorUIResource(255, 0, 0);
    public static final ColorUIResource green = new ColorUIResource(0, 255, 255);
    public static final ColorUIResource cyan = new ColorUIResource(0, 255, 255);
    public static final ColorUIResource white = new ColorUIResource(255, 255, 255);
    public static final ColorUIResource superLightGray = new ColorUIResource(248, 248, 248);
    public static final ColorUIResource extraLightGray = new ColorUIResource(232, 232, 232);
    public static final ColorUIResource lightGray = new ColorUIResource(196, 196, 196);
    public static final ColorUIResource gray = new ColorUIResource(164, 164, 164);
    public static final ColorUIResource darkGray = new ColorUIResource(148, 148, 148);
    public static final ColorUIResource extraDarkGray = new ColorUIResource(96, 96, 96);
    public static final ColorUIResource black = new ColorUIResource(0, 0, 0);
    public static final ColorUIResource orange = new ColorUIResource(255, 200, 0);
    public static final ColorUIResource lightOrange = new ColorUIResource(255, 220, 96);
    public static final ColorUIResource yellow = new ColorUIResource(255, 255, 196);
    public static final ColorUIResource blue = new ColorUIResource(0, 128, 255);
    public static final ColorUIResource darkBlue = new ColorUIResource(0, 64, 128);
    protected static String internalName = "Default";
    protected static boolean windowDecoration = false;
    protected static boolean dynamicLayout = false;
    protected static boolean textAntiAliasing = false;
    protected static int textAntiAliasingMode = 2;
    protected static boolean backgroundPattern = true;
    protected static boolean menuOpaque = true;
    protected static float menuAlpha = 0.9f;
    protected static String logoString = "JTattoo";
    protected static FontUIResource controlFont = null;
    protected static FontUIResource systemFont = null;
    protected static FontUIResource userFont = null;
    protected static FontUIResource smallFont = null;
    protected static FontUIResource menuFont = null;
    protected static FontUIResource windowTitleFont = null;
    protected static ColorUIResource foregroundColor = null;
    protected static ColorUIResource backgroundColor = null;
    protected static ColorUIResource backgroundColorLight = null;
    protected static ColorUIResource backgroundColorDark = null;
    protected static ColorUIResource alterBackgroundColor = null;
    protected static ColorUIResource disabledForegroundColor = null;
    protected static ColorUIResource disabledBackgroundColor = null;
    protected static ColorUIResource inputBackgroundColor = null;
    protected static ColorUIResource inputForegroundColor = null;
    protected static ColorUIResource selectionForegroundColor = null;
    protected static ColorUIResource selectionBackgroundColorLight = null;
    protected static ColorUIResource selectionBackgroundColorDark = null;
    protected static ColorUIResource selectionBackgroundColor = null;
    protected static ColorUIResource rolloverColor = null;
    protected static ColorUIResource rolloverColorLight = null;
    protected static ColorUIResource rolloverColorDark = null;
    protected static ColorUIResource focusColor = null;
    protected static ColorUIResource focusCellColor = null;
    protected static ColorUIResource frameColor = null;
    protected static ColorUIResource gridColor = null;
    protected static ColorUIResource buttonForegroundColor = null;
    protected static ColorUIResource buttonBackgroundColor = null;
    protected static ColorUIResource buttonColorLight = null;
    protected static ColorUIResource buttonColorDark = null;
    protected static ColorUIResource controlForegroundColor = null;
    protected static ColorUIResource controlBackgroundColor = null;
    protected static ColorUIResource controlHighlightColor = null;
    protected static ColorUIResource controlShadowColor = null;
    protected static ColorUIResource controlDarkShadowColor = null;
    protected static ColorUIResource controlColorLight = null;
    protected static ColorUIResource controlColorDark = null;
    protected static ColorUIResource windowTitleForegroundColor = null;
    protected static ColorUIResource windowTitleBackgroundColor = null;
    protected static ColorUIResource windowTitleColorLight = null;
    protected static ColorUIResource windowTitleColorDark = null;
    protected static ColorUIResource windowBorderColor = null;
    protected static ColorUIResource windowInactiveTitleForegroundColor = null;
    protected static ColorUIResource windowInactiveTitleBackgroundColor = null;
    protected static ColorUIResource windowInactiveTitleColorLight = null;
    protected static ColorUIResource windowInactiveTitleColorDark = null;
    protected static ColorUIResource windowInactiveBorderColor = null;
    protected static ColorUIResource menuForegroundColor = null;
    protected static ColorUIResource menuBackgroundColor = null;
    protected static ColorUIResource menuSelectionForegroundColor = null;
    protected static ColorUIResource menuSelectionBackgroundColor = null;
    protected static ColorUIResource menuSelectionBackgroundColorLight = null;
    protected static ColorUIResource menuSelectionBackgroundColorDark = null;
    protected static ColorUIResource menuColorLight = null;
    protected static ColorUIResource menuColorDark = null;
    protected static ColorUIResource toolbarForegroundColor = null;
    protected static ColorUIResource toolbarBackgroundColor = null;
    protected static ColorUIResource toolbarColorLight = null;
    protected static ColorUIResource toolbarColorDark = null;
    protected static ColorUIResource tabAreaBackgroundColor = null;
    protected static ColorUIResource desktopColor = null;
    protected static ColorUIResource tooltipForegroundColor = null;
    protected static ColorUIResource tooltipBackgroundColor = null;
    protected static Color[] DEFAULT_COLORS = null;
    protected static Color[] HIDEFAULT_COLORS = null;
    protected static Color[] ACTIVE_COLORS = null;
    protected static Color[] INACTIVE_COLORS = null;
    protected static Color[] ROLLOVER_COLORS = null;
    protected static Color[] SELECTED_COLORS = null;
    protected static Color[] SELECTION_COLORS = null;
    protected static Color[] MENU_SELECTION_COLORS = null;
    protected static Color[] PRESSED_COLORS = null;
    protected static Color[] DISABLED_COLORS = null;
    protected static Color[] WINDOW_TITLE_COLORS = null;
    protected static Color[] WINDOW_INACTIVE_TITLE_COLORS = null;
    protected static Color[] TOOLBAR_COLORS = null;
    protected static Color[] MENUBAR_COLORS = null;
    protected static Color[] BUTTON_COLORS = null;
    protected static Color[] TAB_COLORS = null;
    protected static Color[] COL_HEADER_COLORS = null;
    protected static Color[] TRACK_COLORS = null;
    protected static Color[] THUMB_COLORS = null;
    protected static Color[] SLIDER_COLORS = null;
    protected static Color[] PROGRESSBAR_COLORS = null;

    public String getName() {
        return AbstractTheme.getInternalName();
    }

    public static String getInternalName() {
        return internalName;
    }

    public static void setInternalName(String string) {
        internalName = string;
    }

    public String getPropertyFileName() {
        return "JTattooTheme.properties";
    }

    public void setUpColor() {
        windowDecoration = true;
        dynamicLayout = true;
        textAntiAliasing = false;
        textAntiAliasingMode = 2;
        backgroundPattern = true;
        menuOpaque = true;
        menuAlpha = 0.9f;
        logoString = "JTattoo";
        controlFont = null;
        systemFont = null;
        userFont = null;
        smallFont = null;
        menuFont = null;
        windowTitleFont = null;
        foregroundColor = black;
        backgroundColor = extraLightGray;
        backgroundColorLight = white;
        backgroundColorDark = extraLightGray;
        alterBackgroundColor = lightGray;
        disabledForegroundColor = gray;
        disabledBackgroundColor = superLightGray;
        inputBackgroundColor = white;
        inputForegroundColor = black;
        selectionForegroundColor = black;
        selectionBackgroundColor = lightGray;
        selectionBackgroundColorLight = extraLightGray;
        selectionBackgroundColorDark = lightGray;
        focusColor = orange;
        focusCellColor = orange;
        frameColor = darkGray;
        gridColor = gray;
        rolloverColor = extraLightGray;
        rolloverColorLight = white;
        rolloverColorDark = extraLightGray;
        buttonForegroundColor = black;
        buttonBackgroundColor = lightGray;
        buttonColorLight = white;
        buttonColorDark = lightGray;
        controlForegroundColor = black;
        controlBackgroundColor = lightGray;
        controlHighlightColor = white;
        controlShadowColor = lightGray;
        controlDarkShadowColor = darkGray;
        controlColorLight = white;
        controlColorDark = lightGray;
        windowTitleForegroundColor = black;
        windowTitleBackgroundColor = blue;
        windowTitleColorLight = extraLightGray;
        windowTitleColorDark = lightGray;
        windowBorderColor = lightGray;
        windowInactiveTitleForegroundColor = black;
        windowInactiveTitleBackgroundColor = extraLightGray;
        windowInactiveTitleColorLight = white;
        windowInactiveTitleColorDark = extraLightGray;
        windowInactiveBorderColor = extraLightGray;
        menuForegroundColor = black;
        menuBackgroundColor = extraLightGray;
        menuSelectionForegroundColor = black;
        menuSelectionBackgroundColor = lightGray;
        menuSelectionBackgroundColorLight = extraLightGray;
        menuSelectionBackgroundColorDark = lightGray;
        menuColorLight = extraLightGray;
        menuColorDark = lightGray;
        toolbarForegroundColor = black;
        toolbarBackgroundColor = lightGray;
        toolbarColorLight = white;
        toolbarColorDark = lightGray;
        tabAreaBackgroundColor = backgroundColor;
        desktopColor = darkBlue;
        tooltipForegroundColor = black;
        tooltipBackgroundColor = yellow;
    }

    public void setUpColorArrs() {
        DEFAULT_COLORS = ColorHelper.createColorArr(controlColorLight, controlColorDark, 20);
        HIDEFAULT_COLORS = ColorHelper.createColorArr(ColorHelper.brighter(controlColorLight, 40.0), ColorHelper.brighter(controlColorDark, 40.0), 20);
        ACTIVE_COLORS = DEFAULT_COLORS;
        INACTIVE_COLORS = HIDEFAULT_COLORS;
        ROLLOVER_COLORS = ColorHelper.createColorArr(rolloverColorLight, rolloverColorDark, 20);
        SELECTED_COLORS = DEFAULT_COLORS;
        SELECTION_COLORS = ColorHelper.createColorArr(selectionBackgroundColorLight, selectionBackgroundColorDark, 20);
        MENU_SELECTION_COLORS = ColorHelper.createColorArr(menuSelectionBackgroundColorLight, menuSelectionBackgroundColorDark, 20);
        PRESSED_COLORS = DEFAULT_COLORS;
        DISABLED_COLORS = HIDEFAULT_COLORS;
        WINDOW_TITLE_COLORS = ColorHelper.createColorArr(windowTitleColorLight, windowTitleColorDark, 20);
        WINDOW_INACTIVE_TITLE_COLORS = ColorHelper.createColorArr(windowInactiveTitleColorLight, windowInactiveTitleColorDark, 20);
        TOOLBAR_COLORS = ColorHelper.createColorArr(toolbarColorLight, toolbarColorDark, 20);
        MENUBAR_COLORS = ColorHelper.createColorArr(menuColorLight, menuColorDark, 20);
        BUTTON_COLORS = ColorHelper.createColorArr(buttonColorLight, buttonColorDark, 20);
        TAB_COLORS = DEFAULT_COLORS;
        COL_HEADER_COLORS = DEFAULT_COLORS;
        TRACK_COLORS = ColorHelper.createColorArr(new Color(220, 220, 220), Color.white, 20);
        THUMB_COLORS = DEFAULT_COLORS;
        SLIDER_COLORS = DEFAULT_COLORS;
        PROGRESSBAR_COLORS = DEFAULT_COLORS;
    }

    public void setProperties(Properties properties) {
        if (properties != null) {
            if (properties.getProperty("windowDecoration") != null) {
                windowDecoration = properties.getProperty("windowDecoration").trim().equalsIgnoreCase("on");
            }
            if (properties.getProperty("dynamicLayout") != null) {
                dynamicLayout = properties.getProperty("dynamicLayout").trim().equalsIgnoreCase("on");
            }
            if (properties.getProperty("textAntiAliasing") != null) {
                textAntiAliasing = properties.getProperty("textAntiAliasing").trim().equalsIgnoreCase("on");
            }
            if (properties.getProperty("textAntiAliasingMode") != null) {
                String string = properties.getProperty("textAntiAliasingMode");
                if (string.equalsIgnoreCase("default")) {
                    textAntiAliasingMode = 0;
                }
                if (string.equalsIgnoreCase("gray")) {
                    textAntiAliasingMode = 1;
                }
                if (string.equalsIgnoreCase("hrgb")) {
                    textAntiAliasingMode = 2;
                }
                if (string.equalsIgnoreCase("hbgr")) {
                    textAntiAliasingMode = 3;
                }
                if (string.equalsIgnoreCase("vrgb")) {
                    textAntiAliasingMode = 4;
                }
                if (string.equalsIgnoreCase("vbgr")) {
                    textAntiAliasingMode = 5;
                }
            }
            if (properties.getProperty("backgroundPattern") != null) {
                backgroundPattern = properties.getProperty("backgroundPattern").trim().equalsIgnoreCase("on");
            }
            if (properties.getProperty("menuOpaque") != null) {
                menuOpaque = properties.getProperty("menuOpaque").trim().equalsIgnoreCase("on");
            }
            if (properties.getProperty("logoString") != null) {
                logoString = properties.getProperty("logoString").trim();
            }
            if (properties.getProperty("controlTextFont") != null) {
                controlFont = AbstractTheme.createFont(properties.getProperty("controlTextFont"));
            }
            if (properties.getProperty("systemTextFont") != null) {
                systemFont = AbstractTheme.createFont(properties.getProperty("systemTextFont"));
            }
            if (properties.getProperty("userTextFont") != null) {
                userFont = AbstractTheme.createFont(properties.getProperty("userTextFont"));
            }
            if (properties.getProperty("menuTextFont") != null) {
                menuFont = AbstractTheme.createFont(properties.getProperty("menuTextFont"));
            }
            if (properties.getProperty("windowTitleFont") != null) {
                windowTitleFont = AbstractTheme.createFont(properties.getProperty("windowTitleFont"));
            }
            if (properties.getProperty("subTextFont") != null) {
                smallFont = AbstractTheme.createFont(properties.getProperty("subTextFont"));
            }
            if (properties.getProperty("foregroundColor") != null) {
                foregroundColor = AbstractTheme.createColor(properties.getProperty("foregroundColor"), foregroundColor);
            }
            if (properties.getProperty("backgroundColor") != null) {
                backgroundColor = AbstractTheme.createColor(properties.getProperty("backgroundColor"), backgroundColor);
            }
            if (properties.getProperty("backgroundColorLight") != null) {
                backgroundColorLight = AbstractTheme.createColor(properties.getProperty("backgroundColorLight"), backgroundColorLight);
            }
            if (properties.getProperty("backgroundColorDark") != null) {
                backgroundColorDark = AbstractTheme.createColor(properties.getProperty("backgroundColorDark"), backgroundColorDark);
            }
            if (properties.getProperty("alterBackgroundColor") != null) {
                alterBackgroundColor = AbstractTheme.createColor(properties.getProperty("alterBackgroundColor"), alterBackgroundColor);
            }
            if (properties.getProperty("disabledForegroundColor") != null) {
                disabledForegroundColor = AbstractTheme.createColor(properties.getProperty("disabledForegroundColor"), disabledForegroundColor);
            }
            if (properties.getProperty("disabledBackgroundColor") != null) {
                disabledBackgroundColor = AbstractTheme.createColor(properties.getProperty("disabledBackgroundColor"), disabledBackgroundColor);
            }
            if (properties.getProperty("inputForegroundColor") != null) {
                inputForegroundColor = AbstractTheme.createColor(properties.getProperty("inputForegroundColor"), inputForegroundColor);
            }
            if (properties.getProperty("inputBackgroundColor") != null) {
                inputBackgroundColor = AbstractTheme.createColor(properties.getProperty("inputBackgroundColor"), inputBackgroundColor);
            }
            if (properties.getProperty("selectionForegroundColor") != null) {
                selectionForegroundColor = AbstractTheme.createColor(properties.getProperty("selectionForegroundColor"), selectionForegroundColor);
            }
            if (properties.getProperty("selectionBackgroundColor") != null) {
                selectionBackgroundColor = AbstractTheme.createColor(properties.getProperty("selectionBackgroundColor"), selectionBackgroundColor);
            }
            if (properties.getProperty("selectionBackgroundColorLight") != null) {
                selectionBackgroundColorLight = AbstractTheme.createColor(properties.getProperty("selectionBackgroundColorLight"), selectionBackgroundColorLight);
            }
            if (properties.getProperty("selectionBackgroundColorDark") != null) {
                selectionBackgroundColorDark = AbstractTheme.createColor(properties.getProperty("selectionBackgroundColorDark"), selectionBackgroundColorDark);
            }
            if (properties.getProperty("frameColor") != null) {
                frameColor = AbstractTheme.createColor(properties.getProperty("frameColor"), frameColor);
            }
            if (properties.getProperty("gridColor") != null) {
                gridColor = AbstractTheme.createColor(properties.getProperty("gridColor"), gridColor);
            }
            if (properties.getProperty("focusColor") != null) {
                focusColor = AbstractTheme.createColor(properties.getProperty("focusColor"), focusColor);
            }
            if (properties.getProperty("focusCellColor") != null) {
                focusCellColor = AbstractTheme.createColor(properties.getProperty("focusCellColor"), focusCellColor);
            }
            if (properties.getProperty("rolloverColor") != null) {
                rolloverColor = AbstractTheme.createColor(properties.getProperty("rolloverColor"), rolloverColor);
            }
            if (properties.getProperty("rolloverColorLight") != null) {
                rolloverColorLight = AbstractTheme.createColor(properties.getProperty("rolloverColorLight"), rolloverColorLight);
            }
            if (properties.getProperty("rolloverColorDark") != null) {
                rolloverColorDark = AbstractTheme.createColor(properties.getProperty("rolloverColorDark"), rolloverColorDark);
            }
            if (properties.getProperty("buttonForegroundColor") != null) {
                buttonForegroundColor = AbstractTheme.createColor(properties.getProperty("buttonForegroundColor"), buttonForegroundColor);
            }
            if (properties.getProperty("buttonBackgroundColor") != null) {
                buttonBackgroundColor = AbstractTheme.createColor(properties.getProperty("buttonBackgroundColor"), buttonBackgroundColor);
            }
            if (properties.getProperty("buttonColorLight") != null) {
                buttonColorLight = AbstractTheme.createColor(properties.getProperty("buttonColorLight"), buttonColorLight);
            }
            if (properties.getProperty("buttonColorDark") != null) {
                buttonColorDark = AbstractTheme.createColor(properties.getProperty("buttonColorDark"), buttonColorDark);
            }
            if (properties.getProperty("controlForegroundColor") != null) {
                controlForegroundColor = AbstractTheme.createColor(properties.getProperty("controlForegroundColor"), controlForegroundColor);
            }
            if (properties.getProperty("controlBackgroundColor") != null) {
                controlBackgroundColor = AbstractTheme.createColor(properties.getProperty("controlBackgroundColor"), controlBackgroundColor);
            }
            if (properties.getProperty("controlColorLight") != null) {
                controlColorLight = AbstractTheme.createColor(properties.getProperty("controlColorLight"), controlColorLight);
            }
            if (properties.getProperty("controlColorDark") != null) {
                controlColorDark = AbstractTheme.createColor(properties.getProperty("controlColorDark"), controlColorDark);
            }
            if (properties.getProperty("controlDarkShadowColor") != null) {
                controlDarkShadowColor = AbstractTheme.createColor(properties.getProperty("controlDarkShadowColor"), controlDarkShadowColor);
            }
            if (properties.getProperty("windowTitleForegroundColor") != null) {
                windowTitleForegroundColor = AbstractTheme.createColor(properties.getProperty("windowTitleForegroundColor"), windowTitleForegroundColor);
            }
            if (properties.getProperty("windowTitleBackgroundColor") != null) {
                windowTitleBackgroundColor = AbstractTheme.createColor(properties.getProperty("windowTitleBackgroundColor"), windowTitleBackgroundColor);
            }
            if (properties.getProperty("windowTitleColorLight") != null) {
                windowTitleColorLight = AbstractTheme.createColor(properties.getProperty("windowTitleColorLight"), windowTitleColorLight);
            }
            if (properties.getProperty("windowTitleColorDark") != null) {
                windowTitleColorDark = AbstractTheme.createColor(properties.getProperty("windowTitleColorDark"), windowTitleColorDark);
            }
            if (properties.getProperty("windowBorderColor") != null) {
                windowBorderColor = AbstractTheme.createColor(properties.getProperty("windowBorderColor"), windowBorderColor);
            }
            if (properties.getProperty("windowInactiveTitleForegroundColor") != null) {
                windowInactiveTitleForegroundColor = AbstractTheme.createColor(properties.getProperty("windowInactiveTitleForegroundColor"), windowInactiveTitleForegroundColor);
            }
            if (properties.getProperty("windowTitleBackgroundColor") != null) {
                windowInactiveTitleBackgroundColor = AbstractTheme.createColor(properties.getProperty("windowInactiveTitleBackgroundColor"), windowInactiveTitleBackgroundColor);
            }
            if (properties.getProperty("windowInactiveTitleColorLight") != null) {
                windowInactiveTitleColorLight = AbstractTheme.createColor(properties.getProperty("windowInactiveTitleColorLight"), windowInactiveTitleColorLight);
            }
            if (properties.getProperty("windowInactiveTitleColorDark") != null) {
                windowInactiveTitleColorDark = AbstractTheme.createColor(properties.getProperty("windowInactiveTitleColorDark"), windowInactiveTitleColorDark);
            }
            if (properties.getProperty("windowInactiveBorderColor") != null) {
                windowInactiveBorderColor = AbstractTheme.createColor(properties.getProperty("windowInactiveBorderColor"), windowInactiveBorderColor);
            }
            if (properties.getProperty("menuForegroundColor") != null) {
                menuForegroundColor = AbstractTheme.createColor(properties.getProperty("menuForegroundColor"), menuForegroundColor);
            }
            if (properties.getProperty("menuBackgroundColor") != null) {
                menuBackgroundColor = AbstractTheme.createColor(properties.getProperty("menuBackgroundColor"), menuBackgroundColor);
            }
            if (properties.getProperty("menuSelectionForegroundColor") != null) {
                menuSelectionForegroundColor = AbstractTheme.createColor(properties.getProperty("menuSelectionForegroundColor"), menuSelectionForegroundColor);
            }
            if (properties.getProperty("menuSelectionBackgroundColor") != null) {
                menuSelectionBackgroundColor = AbstractTheme.createColor(properties.getProperty("menuSelectionBackgroundColor"), menuSelectionBackgroundColor);
            }
            if (properties.getProperty("menuSelectionBackgroundColorLight") != null) {
                menuSelectionBackgroundColorLight = AbstractTheme.createColor(properties.getProperty("menuSelectionBackgroundColorLight"), menuSelectionBackgroundColorLight);
            }
            if (properties.getProperty("menuSelectionBackgroundColorDark") != null) {
                menuSelectionBackgroundColorDark = AbstractTheme.createColor(properties.getProperty("menuSelectionBackgroundColorDark"), menuSelectionBackgroundColorDark);
            }
            if (properties.getProperty("menuColorLight") != null) {
                menuColorLight = AbstractTheme.createColor(properties.getProperty("menuColorLight"), menuColorLight);
            }
            if (properties.getProperty("menuColorDark") != null) {
                menuColorDark = AbstractTheme.createColor(properties.getProperty("menuColorDark"), menuColorDark);
            }
            if (properties.getProperty("toolbarForegroundColor") != null) {
                toolbarForegroundColor = AbstractTheme.createColor(properties.getProperty("toolbarForegroundColor"), toolbarForegroundColor);
            }
            if (properties.getProperty("toolbarBackgroundColor") != null) {
                toolbarBackgroundColor = AbstractTheme.createColor(properties.getProperty("toolbarBackgroundColor"), toolbarBackgroundColor);
            }
            if (properties.getProperty("toolbarColorLight") != null) {
                toolbarColorLight = AbstractTheme.createColor(properties.getProperty("toolbarColorLight"), toolbarColorLight);
            }
            if (properties.getProperty("toolbarColorDark") != null) {
                toolbarColorDark = AbstractTheme.createColor(properties.getProperty("toolbarColorDark"), toolbarColorDark);
            }
            tabAreaBackgroundColor = properties.getProperty("tabAreaBackgroundColor") != null ? AbstractTheme.createColor(properties.getProperty("tabAreaBackgroundColor"), tabAreaBackgroundColor) : backgroundColor;
            if (properties.getProperty("desktopColor") != null) {
                desktopColor = AbstractTheme.createColor(properties.getProperty("desktopColor"), desktopColor);
            }
            if (properties.getProperty("tooltipForegroundColor") != null) {
                tooltipForegroundColor = AbstractTheme.createColor(properties.getProperty("tooltipForegroundColor"), tooltipForegroundColor);
            }
            if (properties.getProperty("tooltipBackgroundColor") != null) {
                tooltipBackgroundColor = AbstractTheme.createColor(properties.getProperty("tooltipBackgroundColor"), tooltipBackgroundColor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties() {
        FileInputStream fileInputStream = null;
        try {
            String string = System.getProperty("user.home") + "/.jtattoo/" + this.getPropertyFileName();
            Properties properties = new Properties();
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            this.setProperties(properties);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected static FontUIResource createFont(String string) {
        if (string != null && string.trim().length() > 5) {
            return new FontUIResource(Font.decode(string));
        }
        return null;
    }

    protected static ColorUIResource createColor(String string, ColorUIResource colorUIResource) {
        if (string != null && string.trim().length() >= 5) {
            string = string.trim();
            int n = colorUIResource.getRed();
            int n2 = colorUIResource.getGreen();
            int n3 = colorUIResource.getBlue();
            try {
                int n4 = 0;
                int n5 = string.indexOf(32);
                if (n5 > 0) {
                    n = Integer.parseInt(string.substring(n4, n5));
                }
                if ((n5 = string.indexOf(32, n4 = n5 + 1)) > 0) {
                    n2 = Integer.parseInt(string.substring(n4, n5));
                }
                n3 = Integer.parseInt(string.substring(n5 + 1));
                return new ColorUIResource(n, n2, n3);
            }
            catch (Exception exception) {
                System.out.println("Exception while parsing color: " + string);
            }
        }
        return colorUIResource;
    }

    public FontUIResource getControlTextFont() {
        if (controlFont == null) {
            controlFont = JTattooUtilities.isLinux() && JTattooUtilities.isHiresScreen() ? new FontUIResource(DIALOG, 1, 14) : new FontUIResource(DIALOG, 0, 12);
        }
        return controlFont;
    }

    public FontUIResource getSystemTextFont() {
        if (systemFont == null) {
            systemFont = JTattooUtilities.isLinux() && JTattooUtilities.isHiresScreen() ? new FontUIResource(DIALOG, 1, 14) : new FontUIResource(DIALOG, 0, 12);
        }
        return systemFont;
    }

    public FontUIResource getUserTextFont() {
        if (userFont == null) {
            userFont = JTattooUtilities.isLinux() && JTattooUtilities.isHiresScreen() ? new FontUIResource(DIALOG, 1, 14) : new FontUIResource(DIALOG, 0, 12);
        }
        return userFont;
    }

    public FontUIResource getMenuTextFont() {
        if (menuFont == null) {
            menuFont = JTattooUtilities.isLinux() && JTattooUtilities.isHiresScreen() ? new FontUIResource(DIALOG, 1, 14) : new FontUIResource(DIALOG, 0, 12);
        }
        return menuFont;
    }

    public FontUIResource getWindowTitleFont() {
        if (windowTitleFont == null) {
            windowTitleFont = JTattooUtilities.isLinux() && JTattooUtilities.isHiresScreen() ? new FontUIResource(DIALOG, 1, 14) : new FontUIResource(DIALOG, 1, 12);
        }
        return windowTitleFont;
    }

    public FontUIResource getSubTextFont() {
        if (smallFont == null) {
            smallFont = JTattooUtilities.isLinux() && JTattooUtilities.isHiresScreen() ? new FontUIResource(DIALOG, 1, 12) : new FontUIResource(DIALOG, 0, 10);
        }
        return smallFont;
    }

    protected ColorUIResource getPrimary1() {
        return foregroundColor;
    }

    protected ColorUIResource getPrimary2() {
        return desktopColor;
    }

    protected ColorUIResource getPrimary3() {
        return selectionBackgroundColor;
    }

    protected ColorUIResource getSecondary1() {
        return frameColor;
    }

    protected ColorUIResource getSecondary2() {
        return controlBackgroundColor;
    }

    protected ColorUIResource getSecondary3() {
        return backgroundColor;
    }

    public ColorUIResource getControl() {
        return controlBackgroundColor;
    }

    public ColorUIResource getControlShadow() {
        return controlShadowColor;
    }

    public ColorUIResource getControlDarkShadow() {
        return controlDarkShadowColor;
    }

    public ColorUIResource getControlInfo() {
        return controlForegroundColor;
    }

    public ColorUIResource getControlHighlight() {
        return controlHighlightColor;
    }

    public ColorUIResource getControlDisabled() {
        return controlShadowColor;
    }

    public ColorUIResource getPrimaryControl() {
        return extraLightGray;
    }

    public ColorUIResource getPrimaryControlShadow() {
        return lightGray;
    }

    public ColorUIResource getPrimaryControlDarkShadow() {
        return gray;
    }

    public ColorUIResource getPrimaryControlInfo() {
        return darkGray;
    }

    public ColorUIResource getPrimaryControlHighlight() {
        return white;
    }

    public ColorUIResource getControlTextColor() {
        return controlForegroundColor;
    }

    public ColorUIResource getSystemTextColor() {
        return foregroundColor;
    }

    public String getLogoString() {
        if (logoString != null && logoString.trim().length() == 0) {
            return null;
        }
        return logoString;
    }

    public boolean isWindowDecorationOn() {
        return windowDecoration;
    }

    public boolean isDynamicLayout() {
        return dynamicLayout;
    }

    public boolean isTextAntiAliasingOn() {
        if (JTattooUtilities.getJavaVersion() < 1.4) {
            return false;
        }
        return textAntiAliasing;
    }

    public int getTextAntiAliasingMode() {
        return textAntiAliasingMode;
    }

    public Object getTextAntiAliasingHint() {
        if (this.isTextAntiAliasingOn()) {
            if (JTattooUtilities.getJavaVersion() >= 1.6) {
                switch (textAntiAliasingMode) {
                    case 0: {
                        return RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
                    }
                    case 2: {
                        return RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                    }
                    case 3: {
                        return RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR;
                    }
                    case 4: {
                        return RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB;
                    }
                    case 5: {
                        return RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
                    }
                }
                return RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            }
            return RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        }
        return RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
    }

    public boolean isBackgroundPatternOn() {
        return backgroundPattern;
    }

    public boolean isMenuOpaque() {
        return menuOpaque;
    }

    public float getMenuAlpha() {
        return menuAlpha;
    }

    public ColorUIResource getForegroundColor() {
        return foregroundColor;
    }

    public ColorUIResource getDisabledForegroundColor() {
        return disabledForegroundColor;
    }

    public ColorUIResource getBackgroundColor() {
        return backgroundColor;
    }

    public ColorUIResource getDisabledBackgroundColor() {
        return disabledBackgroundColor;
    }

    public ColorUIResource getBackgroundColorLight() {
        return backgroundColorLight;
    }

    public ColorUIResource getBackgroundColorDark() {
        return backgroundColorDark;
    }

    public ColorUIResource getAlterBackgroundColor() {
        return alterBackgroundColor;
    }

    public ColorUIResource getInputForegroundColor() {
        return inputForegroundColor;
    }

    public ColorUIResource getInputBackgroundColor() {
        return inputBackgroundColor;
    }

    public ColorUIResource getSelectionForegroundColor() {
        return selectionForegroundColor;
    }

    public ColorUIResource getSelectionBackgroundColorLight() {
        return selectionBackgroundColorLight;
    }

    public ColorUIResource getSelectionBackgroundColorDark() {
        return selectionBackgroundColorDark;
    }

    public ColorUIResource getSelectionBackgroundColor() {
        return selectionBackgroundColor;
    }

    public ColorUIResource getFrameColor() {
        return frameColor;
    }

    public ColorUIResource getGridColor() {
        return gridColor;
    }

    public ColorUIResource getFocusColor() {
        return focusColor;
    }

    public ColorUIResource getFocusCellColor() {
        return focusCellColor;
    }

    public ColorUIResource getRolloverColor() {
        return rolloverColor;
    }

    public ColorUIResource getRolloverColorLight() {
        return rolloverColorLight;
    }

    public ColorUIResource getRolloverColorDark() {
        return rolloverColorDark;
    }

    public ColorUIResource getButtonForegroundColor() {
        return buttonForegroundColor;
    }

    public ColorUIResource getButtonBackgroundColor() {
        return buttonBackgroundColor;
    }

    public ColorUIResource getButtonColorLight() {
        return buttonColorLight;
    }

    public ColorUIResource getButtonColorDark() {
        return buttonColorDark;
    }

    public ColorUIResource getControlForegroundColor() {
        return controlForegroundColor;
    }

    public ColorUIResource getControlBackgroundColor() {
        return controlBackgroundColor;
    }

    public ColorUIResource getControlHighlightColor() {
        return controlHighlightColor;
    }

    public ColorUIResource getControlShadowColor() {
        return controlShadowColor;
    }

    public ColorUIResource getControlDarkShadowColor() {
        return controlDarkShadowColor;
    }

    public ColorUIResource getControlColorLight() {
        return controlColorLight;
    }

    public ColorUIResource getControlColorDark() {
        return controlColorDark;
    }

    public ColorUIResource getWindowTitleForegroundColor() {
        return windowTitleForegroundColor;
    }

    public ColorUIResource getWindowTitleBackgroundColor() {
        return windowTitleBackgroundColor;
    }

    public ColorUIResource getWindowTitleColorLight() {
        return windowTitleColorLight;
    }

    public ColorUIResource getWindowTitleColorDark() {
        return windowTitleColorDark;
    }

    public ColorUIResource getWindowBorderColor() {
        return windowBorderColor;
    }

    public ColorUIResource getWindowInactiveTitleForegroundColor() {
        return windowInactiveTitleForegroundColor;
    }

    public ColorUIResource getWindowInactiveTitleBackgroundColor() {
        return windowInactiveTitleBackgroundColor;
    }

    public ColorUIResource getWindowInactiveTitleColorLight() {
        return windowInactiveTitleColorLight;
    }

    public ColorUIResource getWindowInactiveTitleColorDark() {
        return windowInactiveTitleColorDark;
    }

    public ColorUIResource getWindowInactiveBorderColor() {
        return windowInactiveBorderColor;
    }

    public ColorUIResource getMenuForegroundColor() {
        return menuForegroundColor;
    }

    public ColorUIResource getMenuBackgroundColor() {
        return menuBackgroundColor;
    }

    public ColorUIResource getMenuSelectionForegroundColor() {
        return menuSelectionForegroundColor;
    }

    public ColorUIResource getMenuSelectionBackgroundColor() {
        return menuSelectionBackgroundColor;
    }

    public ColorUIResource getMenuSelectionBackgroundColorLight() {
        return menuSelectionBackgroundColorLight;
    }

    public ColorUIResource getMenuSelectionBackgroundColorDark() {
        return menuSelectionBackgroundColorDark;
    }

    public ColorUIResource getMenuColorLight() {
        return menuColorLight;
    }

    public ColorUIResource getMenuColorDark() {
        return menuColorDark;
    }

    public ColorUIResource getToolbarForegroundColor() {
        return toolbarForegroundColor;
    }

    public ColorUIResource getToolbarBackgroundColor() {
        return toolbarBackgroundColor;
    }

    public ColorUIResource getToolbarColorLight() {
        return toolbarColorLight;
    }

    public ColorUIResource getToolbarColorDark() {
        return toolbarColorDark;
    }

    public ColorUIResource getTabAreaBackgroundColor() {
        return tabAreaBackgroundColor;
    }

    public ColorUIResource getDesktopColor() {
        return desktopColor;
    }

    public ColorUIResource getTooltipForegroundColor() {
        return tooltipForegroundColor;
    }

    public ColorUIResource getTooltipBackgroundColor() {
        return tooltipBackgroundColor;
    }

    public Color[] getDefaultColors() {
        return DEFAULT_COLORS;
    }

    public Color[] getHiDefaultColors() {
        return HIDEFAULT_COLORS;
    }

    public Color[] getActiveColors() {
        return ACTIVE_COLORS;
    }

    public Color[] getInActiveColors() {
        return INACTIVE_COLORS;
    }

    public Color[] getRolloverColors() {
        return ROLLOVER_COLORS;
    }

    public Color[] getSelectedColors() {
        return SELECTED_COLORS;
    }

    public Color[] getSelectionColors() {
        return SELECTION_COLORS;
    }

    public Color[] getMenuSelectionColors() {
        return MENU_SELECTION_COLORS;
    }

    public Color[] getPressedColors() {
        return PRESSED_COLORS;
    }

    public Color[] getDisabledColors() {
        return DISABLED_COLORS;
    }

    public Color[] getWindowTitleColors() {
        return WINDOW_TITLE_COLORS;
    }

    public Color[] getWindowInactiveTitleColors() {
        return WINDOW_INACTIVE_TITLE_COLORS;
    }

    public Color[] getToolBarColors() {
        return TOOLBAR_COLORS;
    }

    public Color[] getMenuBarColors() {
        return MENUBAR_COLORS;
    }

    public Color[] getButtonColors() {
        return BUTTON_COLORS;
    }

    public Color[] getTabColors() {
        return TAB_COLORS;
    }

    public Color[] getColHeaderColors() {
        return COL_HEADER_COLORS;
    }

    public Color[] getTrackColors() {
        return TRACK_COLORS;
    }

    public Color[] getThumbColors() {
        return THUMB_COLORS;
    }

    public Color[] getSliderColors() {
        return SLIDER_COLORS;
    }

    public Color[] getProgressBarColors() {
        return PROGRESSBAR_COLORS;
    }
}

