/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class OSDesktop {
    private static final Logger logger = Logger.getLogger(OSDesktop.class.getName());

    public static void openFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(FileUtils.getAbsolutFile(file));
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
            catch (RuntimeException runtimeException) {
                LogUtils.processException(logger, runtimeException);
            }
        }
    }

    public static void openDirectoryForFile(File file) {
        File file2 = file.getParentFile();
        if (Utils.isWindows() && file.exists()) {
            try {
                Runtime.getRuntime().exec("explorer.exe /n,/e,/select,\"" + file.getAbsolutePath() + '\"');
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
        } else {
            OSDesktop.openFile(file2);
        }
    }
}

