/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;

public final class Crc32 {
    private Crc32() {
    }

    public static byte[] crc32(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return Crc32.crc32ToByteArray(cRC32.getValue());
    }

    public static byte[] crc32(String string) {
        return Crc32.crc32(StringUtils.getBytesUtf8((String)string));
    }

    public static byte[] crc32(InputStream inputStream) throws IOException {
        int n;
        CRC32 cRC32 = new CRC32();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > -1) {
            cRC32.update(byArray, 0, n);
        }
        return Crc32.crc32ToByteArray(cRC32.getValue());
    }

    private static byte[] crc32ToByteArray(long l) {
        byte[] byArray = new byte[4];
        ByteBuffer.wrap(byArray).asIntBuffer().put((int)l);
        return byArray;
    }

    public static String crc32Hex(byte[] byArray) {
        return Hex.encodeHexString((byte[])Crc32.crc32(byArray));
    }

    public static String crc32Hex(String string) {
        return Hex.encodeHexString((byte[])Crc32.crc32(string));
    }

    public static String crc32Hex(InputStream inputStream) throws IOException {
        return Hex.encodeHexString((byte[])Crc32.crc32(inputStream));
    }
}

