/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.WinPreferencesFactory;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.ResourceMap;

public final class AppPrefs {
    private static final Logger logger = Logger.getLogger(AppPrefs.class.getName());
    private final String propertiesFileName;
    private static volatile Preferences properties;
    private final ApplicationContext context;
    private String userNode;
    private static final String CONFIG_DIR = "config";
    private boolean pendingChanges;
    private static final Timer syncTimer;
    private static final int SYNC_INTERVAL = 30;
    private final Object syncLock = new Object();

    AppPrefs(ApplicationContext applicationContext, Map<String, String> map, boolean bl) {
        Object object;
        this.context = applicationContext;
        String string = applicationContext.getResourceMap().getString("Application.id", new Object[0]);
        if (string == null || string.isEmpty()) {
            throw new IllegalStateException("Config property Application.ID is empty!");
        }
        this.propertiesFileName = string.toLowerCase() + ".xml";
        properties = this.loadProperties();
        if (bl) {
            try {
                properties.clear();
            }
            catch (BackingStoreException backingStoreException) {
                LogUtils.processException(logger, backingStoreException);
            }
        }
        if (AppPrefs.getProperty("detectBlindMode", AppPrefs.getProperty("blindMode", false)) && (object = System.getProperty("javax.accessibility.assistive_technologies", null)) != null) {
            logger.info("Detecting blindMode " + (String)object);
            AppPrefs.storeProperty("blindMode", true);
        }
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getValue();
                if ("default".equals(string2)) {
                    properties.remove((String)entry.getKey());
                    continue;
                }
                properties.put((String)entry.getKey(), string2);
            }
        }
        if (Utils.isWindows()) {
            AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Property changed: " + preferenceChangeEvent.getKey());
                    }
                    Object object = AppPrefs.this.syncLock;
                    synchronized (object) {
                        if (!"proxy.password".equals(preferenceChangeEvent.getKey())) {
                            AppPrefs.this.pendingChanges = true;
                        }
                    }
                }
            });
            syncTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = AppPrefs.this.syncLock;
                    synchronized (object) {
                        if (AppPrefs.this.pendingChanges) {
                            AppPrefs.this.sync();
                        }
                    }
                }
            }, 30000L, 30000L);
        }
    }

    public static int getProperty(String string, int n) {
        return AppPrefs.getPreferences().getInt(string, n);
    }

    public static long getProperty(String string, long l) {
        return AppPrefs.getPreferences().getLong(string, l);
    }

    public static boolean getProperty(String string, boolean bl) {
        return AppPrefs.getPreferences().getBoolean(string, bl);
    }

    public static String getProperty(String string) {
        return AppPrefs.getPreferences().get(string, null);
    }

    public static void storeProperty(String string, boolean bl) {
        AppPrefs.getPreferences().putBoolean(string, bl);
    }

    public static void storeProperty(String string, String string2) {
        if (string2 == null) {
            AppPrefs.getPreferences().remove(string);
        } else {
            AppPrefs.getPreferences().put(string, string2);
        }
    }

    public static void storeProperty(String string, int n) {
        AppPrefs.getPreferences().putInt(string, n);
    }

    public static void storeProperty(String string, long l) {
        AppPrefs.getPreferences().putLong(string, l);
    }

    public static String getProperty(String string, String string2) {
        return AppPrefs.getPreferences().get(string, string2);
    }

    public static void removeProperty(String string) {
        AppPrefs.getPreferences().remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        Object object = this.syncLock;
        synchronized (object) {
            this.sync();
        }
    }

    private void sync() {
        OutputStream outputStream = null;
        try {
            if (!AppPrefs.getProperty("proxy.savepassword", false)) {
                AppPrefs.removeProperty("proxy.password");
            }
            LocalStorage localStorage = this.context.getLocalStorage();
            File file = localStorage.getDirectory();
            file.mkdirs();
            outputStream = new FileOutputStream(new File(file, this.propertiesFileName));
            AppPrefs.getPreferences().exportNode(outputStream);
            outputStream.close();
            logger.config("Preferences were saved successfuly");
            this.pendingChanges = false;
        }
        catch (IOException iOException) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException2) {
                logger.log(Level.SEVERE, iOException.getMessage(), iOException2);
            }
            logger.severe("Couldn't save app getPreferences(). This is a fatal error. Please reinstall the application.");
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private String getUserNode() {
        if (this.userNode == null) {
            ResourceMap resourceMap = this.context.getResourceMap();
            String string = resourceMap.getString("Application.vendorId", new Object[0]);
            String string2 = resourceMap.getString("Application.id", new Object[0]);
            if (string.isEmpty() || string2.isEmpty()) {
                logger.warning("AppPrefs - vendor or application ID is empty");
            }
            this.userNode = string.toLowerCase() + "/" + string2.toLowerCase();
        }
        return this.userNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences loadProperties() {
        if (Utils.isWindows()) {
            System.getProperties().put("java.util.prefs.PreferencesFactory", WinPreferencesFactory.class.getName());
        }
        LocalStorage localStorage = this.context.getLocalStorage();
        if (System.getProperties().containsKey("portable")) {
            localStorage.setDirectory(new File(Utils.getAppPath(), CONFIG_DIR));
        }
        File file = localStorage.getDirectory();
        logger.config("Config files directory: " + file.getAbsolutePath());
        File file2 = new File(file, this.propertiesFileName);
        if (!file2.exists()) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "File with user settings " + file2 + " was not found. First run. Using default settings");
            }
            return Preferences.userRoot().node(this.getUserNode());
        }
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(file, this.propertiesFileName));
            Preferences.importPreferences(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.CONFIG, "User preferences file was not found (first application start?)");
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        return Preferences.userRoot().node(this.getUserNode());
    }

    public static void initEmptyPreferences() {
        properties = Preferences.userRoot();
    }

    public static Preferences getPreferences() {
        if (properties == null) {
            throw new IllegalStateException("Properties were not initialized yet");
        }
        return properties;
    }

    public static void negateProperty(String string, boolean bl) {
        AppPrefs.storeProperty(string, !AppPrefs.getProperty(string, bl));
    }

    static {
        syncTimer = new Timer("AppPrefsSyncTimer", true);
    }
}

