/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayDeque;
import java.util.LinkedList;
import java.util.List;
import jlibs.core.graph.Filter;
import jlibs.core.graph.Navigator;
import jlibs.core.graph.Path;
import jlibs.core.graph.Processor;
import jlibs.core.graph.Sequence;
import jlibs.core.graph.SequenceUtil;
import jlibs.core.graph.Visitor;
import jlibs.core.graph.Walker;
import jlibs.core.graph.navigators.FilteredNavigator;
import jlibs.core.graph.visitors.StaticVisitor;
import jlibs.core.graph.walkers.PreorderWalker;
import jlibs.core.io.FileNavigator;

public class WalkerUtil {
    public static <E> void walk(Walker<E> walker, Visitor<E, Processor<E>> visitor) {
        while (true) {
            Processor processor;
            Object elem;
            if ((elem = walker.next()) != null) {
                processor = visitor.visit(elem);
                if (processor != null && !processor.preProcess(elem, walker.getCurrentPath())) {
                    walker.skip();
                }
                walker.addBreakpoint();
                continue;
            }
            if (!walker.isPaused()) break;
            walker.resume();
            elem = walker.current();
            processor = visitor.visit(elem);
            if (processor == null) continue;
            processor.postProcess(elem, walker.getCurrentPath());
        }
    }

    public static <E> void walk(Walker<E> walker, Processor<E> processor) {
        WalkerUtil.walk(walker, new StaticVisitor(processor));
    }

    public static <E> List<E> topologicalSort(Sequence<E> elements, Navigator<E> navigator) {
        final List unvisitedElements = SequenceUtil.addAll(new LinkedList(), elements);
        FilteredNavigator<E> filteredNavigator = new FilteredNavigator<E>(navigator, new Filter<E>(){

            @Override
            public boolean select(E elem) {
                return unvisitedElements.contains(elem);
            }
        });
        final LinkedList result = new LinkedList();
        while (!unvisitedElements.isEmpty()) {
            WalkerUtil.walk(new PreorderWalker(unvisitedElements.remove(0), filteredNavigator), new Processor<E>(){

                @Override
                public boolean preProcess(E elem, Path path) {
                    unvisitedElements.remove(elem);
                    return true;
                }

                @Override
                public void postProcess(E elem, Path path) {
                    result.add(0, elem);
                }
            });
        }
        for (int i = 0; i < result.size(); ++i) {
            E elem;
            Sequence<E> seq = navigator.children(result.get(i));
            while ((elem = seq.next()) != null) {
                if (result.indexOf(elem) >= i) continue;
                throw new IllegalArgumentException("the given graph contains cycle");
            }
        }
        return result;
    }

    public static <E> void print(Walker<E> walker, final Visitor<E, String> visitor) {
        WalkerUtil.walk(walker, new Processor<E>(){
            String pending;
            Path pendingPath;

            private StringBuilder getIndentation(Path path) {
                ArrayDeque<Path> stack = new ArrayDeque<Path>();
                while (path.getParentPath() != null) {
                    stack.push(path);
                    path = path.getParentPath();
                }
                StringBuilder indentString = new StringBuilder();
                while (!stack.isEmpty()) {
                    path = (Path)stack.pop();
                    if (stack.isEmpty()) {
                        indentString.append(path.lastElem ? (char)'`' : '|');
                        indentString.append("-- ");
                        continue;
                    }
                    indentString.append(path.lastElem ? (char)' ' : '|');
                    indentString.append("   ");
                }
                return indentString;
            }

            @Override
            public boolean preProcess(E elem, Path path) {
                this.printPending(path);
                String str = visitor != null ? (String)visitor.visit(elem) : elem.toString();
                System.out.print(this.getIndentation(path));
                int newLine = str.indexOf(10);
                if (newLine != -1) {
                    this.pending = str.substring(newLine + 1);
                    this.pendingPath = path;
                    str = str.substring(0, newLine);
                }
                System.out.println(str);
                return true;
            }

            private void printPending(Path path) {
                if (this.pending != null) {
                    StringBuilder indentStr = this.getIndentation(path.getParentPath() == null ? this.pendingPath : path);
                    if (indentStr.length() > 0) {
                        indentStr.replace(indentStr.length() - 4, indentStr.length(), path.getParentPath() == null ? "   " : "|");
                        if (path.getParentPath() == this.pendingPath.getParentPath()) {
                            indentStr.append("   ");
                        }
                    }
                    int from = 0;
                    int index = 0;
                    while ((index = this.pending.indexOf(10, from)) != -1) {
                        System.out.print(indentStr);
                        System.out.println(this.pending.substring(from, index));
                        from = index + 1;
                    }
                    if (from < this.pending.length()) {
                        System.out.print(indentStr);
                        System.out.println(this.pending.substring(from));
                    }
                    this.pending = null;
                }
            }

            @Override
            public void postProcess(E elem, Path path) {
                if (path.getParentPath() == null) {
                    this.printPending(path);
                }
            }
        });
    }

    public static void main(String[] args) {
        WalkerUtil.print(new PreorderWalker<File>(new File("/Volumes/Softwares/Personal/jlibs/core/src"), new FileNavigator(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() || !file.getName().equals(".svn");
            }
        })), new Visitor<File, String>(){

            @Override
            public String visit(File elem) {
                return elem.getName();
            }
        });
    }
}

