/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http.digest;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.proxy.ProxyAuthException;
import org.apache.mina.proxy.handlers.http.AbstractAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.HttpProxyRequest;
import org.apache.mina.proxy.handlers.http.HttpProxyResponse;
import org.apache.mina.proxy.handlers.http.digest.DigestUtilities;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.proxy.utils.StringUtilities;
import org.apache.mina.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDigestAuthLogicHandler
extends AbstractAuthLogicHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpDigestAuthLogicHandler.class);
    private HashMap<String, String> directives = null;
    private HttpProxyResponse response;
    private static SecureRandom rnd;

    public HttpDigestAuthLogicHandler(ProxyIoSession proxyIoSession) throws ProxyAuthException {
        super(proxyIoSession);
        ((HttpProxyRequest)this.request).checkRequiredProperties("USER", "PWD");
    }

    public void doHandshake(IoFilter.NextFilter nextFilter) throws ProxyAuthException {
        HashMap<String, List<String>> hashMap;
        logger.debug(" doHandshake()");
        if (this.step > 0 && this.directives == null) {
            throw new ProxyAuthException("Authentication challenge not received");
        }
        HttpProxyRequest httpProxyRequest = (HttpProxyRequest)this.request;
        HashMap<String, List<String>> hashMap2 = hashMap = httpProxyRequest.getHeaders() != null ? httpProxyRequest.getHeaders() : new HashMap<String, List<String>>();
        if (this.step > 0) {
            Object object;
            logger.debug("  sending DIGEST challenge response");
            HashMap<String, String> hashMap3 = new HashMap<String, String>();
            hashMap3.put("username", httpProxyRequest.getProperties().get("USER"));
            StringUtilities.copyDirective(this.directives, hashMap3, "realm");
            StringUtilities.copyDirective(this.directives, hashMap3, "uri");
            StringUtilities.copyDirective(this.directives, hashMap3, "opaque");
            StringUtilities.copyDirective(this.directives, hashMap3, "nonce");
            String string = StringUtilities.copyDirective(this.directives, hashMap3, "algorithm");
            if (string != null && !"md5".equalsIgnoreCase(string) && !"md5-sess".equalsIgnoreCase(string)) {
                throw new ProxyAuthException("Unknown algorithm required by server");
            }
            String string2 = this.directives.get("qop");
            if (string2 != null) {
                Iterator<String> iterator;
                object = new StringTokenizer(string2, ",");
                Iterator<String> iterator2 = null;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    iterator = ((StringTokenizer)object).nextToken();
                    if ("auth".equalsIgnoreCase((String)((Object)iterator2))) break;
                    int n = Arrays.binarySearch(DigestUtilities.SUPPORTED_QOPS, iterator);
                    if (n <= -1) continue;
                    iterator2 = iterator;
                }
                if (iterator2 != null) {
                    hashMap3.put("qop", (String)((Object)iterator2));
                    iterator = (Iterator<String>)new byte[8];
                    rnd.nextBytes((byte[])iterator);
                    try {
                        String string3 = new String(Base64.encodeBase64((byte[])iterator), this.proxyIoSession.getCharsetName());
                        hashMap3.put("cnonce", string3);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new ProxyAuthException("Unable to encode cnonce", unsupportedEncodingException);
                    }
                } else {
                    throw new ProxyAuthException("No supported qop option available");
                }
            }
            hashMap3.put("nc", "00000001");
            hashMap3.put("uri", httpProxyRequest.getHttpURI());
            try {
                hashMap3.put("response", DigestUtilities.computeResponseValue(this.proxyIoSession.getSession(), hashMap3, httpProxyRequest.getHttpVerb().toUpperCase(), httpProxyRequest.getProperties().get("PWD"), this.proxyIoSession.getCharsetName(), this.response.getBody()));
            }
            catch (Exception exception) {
                throw new ProxyAuthException("Digest response computing failed", exception);
            }
            object = new StringBuilder("Digest ");
            boolean bl = false;
            for (String string3 : hashMap3.keySet()) {
                if (bl) {
                    ((StringBuilder)object).append(", ");
                } else {
                    bl = true;
                }
                boolean bl2 = !"qop".equals(string3) && !"nc".equals(string3);
                ((StringBuilder)object).append(string3);
                if (bl2) {
                    ((StringBuilder)object).append("=\"").append(hashMap3.get(string3)).append('\"');
                    continue;
                }
                ((StringBuilder)object).append('=').append(hashMap3.get(string3));
            }
            StringUtilities.addValueToHeader(hashMap, "Proxy-Authorization", ((StringBuilder)object).toString(), true);
        }
        HttpDigestAuthLogicHandler.addKeepAliveHeaders(hashMap);
        httpProxyRequest.setHeaders(hashMap);
        this.writeRequest(nextFilter, httpProxyRequest);
        ++this.step;
    }

    public void handleResponse(HttpProxyResponse httpProxyResponse) throws ProxyAuthException {
        this.response = httpProxyResponse;
        if (this.step == 0) {
            if (httpProxyResponse.getStatusCode() != 401 && httpProxyResponse.getStatusCode() != 407) {
                throw new ProxyAuthException("Received unexpected response code (" + httpProxyResponse.getStatusLine() + ").");
            }
            List<String> list = httpProxyResponse.getHeaders().get("Proxy-Authenticate");
            String string = null;
            for (String string2 : list) {
                if (!string2.startsWith("Digest")) continue;
                string = string2;
                break;
            }
            if (string == null) {
                throw new ProxyAuthException("Server doesn't support digest authentication method !");
            }
            try {
                this.directives = StringUtilities.parseDirectives(string.substring(7).getBytes(this.proxyIoSession.getCharsetName()));
            }
            catch (Exception exception) {
                throw new ProxyAuthException("Parsing of server digest directives failed", exception);
            }
        } else {
            throw new ProxyAuthException("Received unexpected response code (" + httpProxyResponse.getStatusLine() + ").");
        }
        this.step = 1;
    }

    static {
        try {
            rnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }
}

