/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.service;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIoProcessorPool<S extends AbstractIoSession>
implements IoProcessor<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleIoProcessorPool.class);
    private static final int DEFAULT_SIZE = Runtime.getRuntime().availableProcessors() + 1;
    private static final AttributeKey PROCESSOR = new AttributeKey(SimpleIoProcessorPool.class, "processor");
    private final IoProcessor<S>[] pool;
    private final Executor executor;
    private final boolean createdExecutor;
    private final Object disposalLock = new Object();
    private volatile boolean disposing;
    private volatile boolean disposed;

    public SimpleIoProcessorPool(Class<? extends IoProcessor<S>> clazz) {
        this(clazz, null, DEFAULT_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleIoProcessorPool(Class<? extends IoProcessor<S>> clazz, Executor executor, int n) {
        if (clazz == null) {
            throw new IllegalArgumentException("processorType");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("size: " + n + " (expected: positive integer)");
        }
        this.createdExecutor = executor == null;
        this.executor = this.createdExecutor ? Executors.newCachedThreadPool() : executor;
        this.pool = new IoProcessor[n];
        boolean bl = false;
        Constructor<IoProcessor<S>> constructor = null;
        boolean bl2 = true;
        try {
            try {
                try {
                    constructor = clazz.getConstructor(ExecutorService.class);
                    this.pool[0] = constructor.newInstance(this.executor);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        constructor = clazz.getConstructor(Executor.class);
                        this.pool[0] = constructor.newInstance(this.executor);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            constructor = clazz.getConstructor(new Class[0]);
                            bl2 = false;
                            this.pool[0] = constructor.newInstance(new Object[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {}
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Cannot create an IoProcessor :{}", (Object)runtimeException.getMessage());
                throw runtimeException;
            }
            catch (Exception exception) {
                String string = "Failed to create a new instance of " + clazz.getName() + ":" + exception.getMessage();
                LOGGER.error(string, (Throwable)exception);
                throw new RuntimeIoException(string, exception);
            }
            if (constructor == null) {
                String string = String.valueOf(clazz) + " must have a public constructor with one " + ExecutorService.class.getSimpleName() + " parameter, a public constructor with one " + Executor.class.getSimpleName() + " parameter or a public default constructor.";
                LOGGER.error(string);
                throw new IllegalArgumentException(string);
            }
            for (int i = 1; i < this.pool.length; ++i) {
                try {
                    if (bl2) {
                        this.pool[i] = constructor.newInstance(this.executor);
                        continue;
                    }
                    this.pool[i] = constructor.newInstance(new Object[0]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bl = true;
        }
        finally {
            if (!bl) {
                this.dispose();
            }
        }
    }

    @Override
    public final void add(S s) {
        this.getProcessor(s).add(s);
    }

    @Override
    public final void flush(S s) {
        this.getProcessor(s).flush(s);
    }

    @Override
    public final void remove(S s) {
        this.getProcessor(s).remove(s);
    }

    @Override
    public boolean isDisposing() {
        return this.disposing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        if (this.disposed) {
            return;
        }
        Object object = this.disposalLock;
        synchronized (object) {
            if (!this.disposing) {
                this.disposing = true;
                for (IoProcessor<S> ioProcessor : this.pool) {
                    if (ioProcessor.isDisposing()) continue;
                    try {
                        ioProcessor.dispose();
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Failed to dispose the {} IoProcessor.", (Object)ioProcessor.getClass().getSimpleName(), (Object)exception);
                    }
                }
                if (this.createdExecutor) {
                    ((ExecutorService)this.executor).shutdown();
                }
            }
            Arrays.fill(this.pool, null);
            this.disposed = true;
        }
    }

    private IoProcessor<S> getProcessor(S s) {
        IoProcessor<S> ioProcessor = (IoProcessor<S>)((AbstractIoSession)s).getAttribute(PROCESSOR);
        if (ioProcessor == null) {
            if (this.disposed || this.disposing) {
                throw new IllegalStateException("A disposed processor cannot be accessed.");
            }
            ioProcessor = this.pool[Math.abs((int)((AbstractIoSession)s).getId()) % this.pool.length];
            ((AbstractIoSession)s).setAttributeIfAbsent(PROCESSOR, ioProcessor);
        }
        return ioProcessor;
    }
}

