/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.polling;

import java.io.IOException;
import java.net.PortUnreachableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.future.DefaultIoFuture;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoServiceListenerSupport;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.session.SessionState;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;
import org.apache.mina.core.write.WriteToClosedSessionException;
import org.apache.mina.transport.socket.AbstractDatagramSessionConfig;
import org.apache.mina.util.ExceptionMonitor;
import org.apache.mina.util.NamePreservingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPollingIoProcessor<S extends AbstractIoSession>
implements IoProcessor<S> {
    private static final Logger LOG = LoggerFactory.getLogger(IoProcessor.class);
    private static final Map<Class<?>, AtomicInteger> threadIds = new ConcurrentHashMap();
    private final Object lock = new Object();
    private final String threadName;
    private final Executor executor;
    private final Queue<S> newSessions = new ConcurrentLinkedQueue<S>();
    private final Queue<S> removingSessions = new ConcurrentLinkedQueue<S>();
    private final Queue<S> flushingSessions = new ConcurrentLinkedQueue<S>();
    private final Queue<S> trafficControllingSessions = new ConcurrentLinkedQueue<S>();
    private Processor processor;
    private long lastIdleCheckTime;
    private final Object disposalLock = new Object();
    private volatile boolean disposing;
    private volatile boolean disposed;
    private final DefaultIoFuture disposalFuture = new DefaultIoFuture(null);
    protected AtomicBoolean wakeupCalled = new AtomicBoolean(false);

    protected AbstractPollingIoProcessor(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor");
        }
        this.threadName = this.nextThreadName();
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextThreadName() {
        int n;
        Class<?> clazz = this.getClass();
        Map<Class<?>, AtomicInteger> map = threadIds;
        synchronized (map) {
            AtomicInteger atomicInteger = threadIds.get(clazz);
            if (atomicInteger == null) {
                n = 1;
                threadIds.put(clazz, new AtomicInteger(n));
            } else {
                n = atomicInteger.incrementAndGet();
            }
        }
        return clazz.getSimpleName() + '-' + n;
    }

    @Override
    public final boolean isDisposing() {
        return this.disposing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        if (this.disposed || this.disposing) {
            return;
        }
        Object object = this.disposalLock;
        synchronized (object) {
            this.disposing = true;
            this.startupProcessor();
        }
        this.disposalFuture.awaitUninterruptibly();
        this.disposed = true;
    }

    protected abstract void doDispose() throws Exception;

    protected abstract int select(long var1) throws Exception;

    protected abstract boolean isSelectorEmpty();

    protected abstract void wakeup();

    protected abstract Iterator<S> allSessions();

    protected abstract Iterator<S> selectedSessions();

    protected abstract SessionState getState(S var1);

    protected abstract boolean isWritable(S var1);

    protected abstract boolean isReadable(S var1);

    protected abstract void setInterestedInWrite(S var1, boolean var2) throws Exception;

    protected abstract void setInterestedInRead(S var1, boolean var2) throws Exception;

    protected abstract void init(S var1) throws Exception;

    protected abstract void destroy(S var1) throws Exception;

    protected abstract int read(S var1, IoBuffer var2) throws Exception;

    protected abstract int write(S var1, IoBuffer var2, int var3) throws Exception;

    protected abstract int transferFile(S var1, FileRegion var2, int var3) throws Exception;

    @Override
    public final void add(S s) {
        if (this.disposed || this.disposing) {
            throw new IllegalStateException("Already disposed.");
        }
        this.newSessions.add(s);
        this.startupProcessor();
    }

    @Override
    public final void remove(S s) {
        this.scheduleRemove(s);
        this.startupProcessor();
    }

    private void scheduleRemove(S s) {
        this.removingSessions.add(s);
    }

    @Override
    public final void flush(S s) {
        if (((AbstractIoSession)s).setScheduledForFlush(true)) {
            this.flushingSessions.add(s);
            this.wakeup();
        }
    }

    private void scheduleFlush(S s) {
        if (((AbstractIoSession)s).setScheduledForFlush(true)) {
            this.flushingSessions.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupProcessor() {
        Object object = this.lock;
        synchronized (object) {
            if (this.processor == null) {
                this.processor = new Processor();
                this.executor.execute(new NamePreservingRunnable(this.processor, this.threadName));
            }
        }
        this.wakeup();
    }

    private int handleNewSessions() {
        int n = 0;
        AbstractIoSession abstractIoSession = (AbstractIoSession)this.newSessions.poll();
        while (abstractIoSession != null) {
            if (this.addNow(abstractIoSession)) {
                ++n;
            }
            abstractIoSession = (AbstractIoSession)this.newSessions.poll();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addNow(S s) {
        boolean bl = false;
        try {
            this.init(s);
            bl = true;
            IoFilterChainBuilder ioFilterChainBuilder = ((AbstractIoSession)s).getService().getFilterChainBuilder();
            ioFilterChainBuilder.buildFilterChain(s.getFilterChain());
            IoServiceListenerSupport ioServiceListenerSupport = ((AbstractIoService)((AbstractIoSession)s).getService()).getListeners();
            ioServiceListenerSupport.fireSessionCreated((IoSession)s);
        }
        catch (Throwable throwable) {
            ExceptionMonitor.getInstance().exceptionCaught(throwable);
            try {
                this.destroy(s);
            }
            catch (Exception exception) {
                ExceptionMonitor.getInstance().exceptionCaught(exception);
            }
            finally {
                bl = false;
            }
        }
        return bl;
    }

    private int removeSessions() {
        int n = 0;
        AbstractIoSession abstractIoSession = (AbstractIoSession)this.removingSessions.poll();
        while (abstractIoSession != null) {
            SessionState sessionState = this.getState(abstractIoSession);
            switch (sessionState) {
                case OPENED: {
                    if (!this.removeNow(abstractIoSession)) break;
                    ++n;
                    break;
                }
                case CLOSING: {
                    break;
                }
                case OPENING: {
                    this.newSessions.remove(abstractIoSession);
                    if (!this.removeNow(abstractIoSession)) break;
                    ++n;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)sessionState));
                }
            }
            abstractIoSession = (AbstractIoSession)this.removingSessions.poll();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeNow(S s) {
        this.clearWriteRequestQueue(s);
        try {
            this.destroy(s);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            IoFilterChain ioFilterChain = s.getFilterChain();
            ioFilterChain.fireExceptionCaught(exception);
        }
        finally {
            this.clearWriteRequestQueue(s);
            ((AbstractIoService)((AbstractIoSession)s).getService()).getListeners().fireSessionDestroyed((IoSession)s);
        }
        return false;
    }

    private void clearWriteRequestQueue(S s) {
        Object object;
        Object object2;
        WriteRequestQueue writeRequestQueue = ((AbstractIoSession)s).getWriteRequestQueue();
        ArrayList<WriteRequest> arrayList = new ArrayList<WriteRequest>();
        WriteRequest writeRequest = writeRequestQueue.poll((IoSession)s);
        if (writeRequest != null) {
            object2 = writeRequest.getMessage();
            if (object2 instanceof IoBuffer) {
                object = (IoBuffer)object2;
                if (((IoBuffer)object).hasRemaining()) {
                    ((IoBuffer)object).reset();
                    arrayList.add(writeRequest);
                } else {
                    IoFilterChain object3 = s.getFilterChain();
                    object3.fireMessageSent(writeRequest);
                }
            } else {
                arrayList.add(writeRequest);
            }
            while ((writeRequest = writeRequestQueue.poll((IoSession)s)) != null) {
                arrayList.add(writeRequest);
            }
        }
        if (!arrayList.isEmpty()) {
            object2 = new WriteToClosedSessionException(arrayList);
            for (WriteRequest writeRequest2 : arrayList) {
                ((AbstractIoSession)s).decreaseScheduledBytesAndMessages(writeRequest2);
                writeRequest2.getFuture().setException((Throwable)object2);
            }
            object = s.getFilterChain();
            object.fireExceptionCaught((Throwable)object2);
        }
    }

    private void process() throws Exception {
        Iterator<S> iterator = this.selectedSessions();
        while (iterator.hasNext()) {
            AbstractIoSession abstractIoSession = (AbstractIoSession)iterator.next();
            this.process(abstractIoSession);
            iterator.remove();
        }
    }

    private void process(S s) {
        if (this.isReadable(s) && !((AbstractIoSession)s).isReadSuspended()) {
            this.read(s);
        }
        if (this.isWritable(s) && !((AbstractIoSession)s).isWriteSuspended() && ((AbstractIoSession)s).setScheduledForFlush(true)) {
            this.flushingSessions.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(S s) {
        IoSessionConfig ioSessionConfig = ((AbstractIoSession)s).getConfig();
        int n = ioSessionConfig.getReadBufferSize();
        IoBuffer ioBuffer = IoBuffer.allocate(n);
        boolean bl = s.getTransportMetadata().hasFragmentation();
        try {
            int n2;
            int n3;
            block15: {
                n3 = 0;
                try {
                    if (bl) {
                        while ((n2 = this.read(s, ioBuffer)) > 0) {
                            n3 += n2;
                            if (ioBuffer.hasRemaining()) continue;
                            break block15;
                        }
                        break block15;
                    }
                    n2 = this.read(s, ioBuffer);
                    if (n2 > 0) {
                        n3 = n2;
                    }
                }
                finally {
                    ioBuffer.flip();
                }
            }
            if (n3 > 0) {
                IoFilterChain ioFilterChain = s.getFilterChain();
                ioFilterChain.fireMessageReceived(ioBuffer);
                ioBuffer = null;
                if (bl) {
                    if (n3 << 1 < ioSessionConfig.getReadBufferSize()) {
                        ((AbstractIoSession)s).decreaseReadBufferSize();
                    } else if (n3 == ioSessionConfig.getReadBufferSize()) {
                        ((AbstractIoSession)s).increaseReadBufferSize();
                    }
                }
            }
            if (n2 < 0) {
                this.scheduleRemove(s);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException && (!(throwable instanceof PortUnreachableException) || !AbstractDatagramSessionConfig.class.isAssignableFrom(ioSessionConfig.getClass()) || ((AbstractDatagramSessionConfig)ioSessionConfig).isCloseOnPortUnreachable())) {
                this.scheduleRemove(s);
            }
            IoFilterChain ioFilterChain = s.getFilterChain();
            ioFilterChain.fireExceptionCaught(throwable);
        }
    }

    private void notifyIdleSessions(long l) throws Exception {
        if (l - this.lastIdleCheckTime >= 1000L) {
            this.lastIdleCheckTime = l;
            AbstractIoSession.notifyIdleness(this.allSessions(), l);
        }
    }

    @Override
    private void flush(long l) {
        AbstractIoSession abstractIoSession;
        if (this.flushingSessions.isEmpty()) {
            return;
        }
        while ((abstractIoSession = (AbstractIoSession)this.flushingSessions.poll()) != null) {
            abstractIoSession.unscheduledForFlush();
            SessionState sessionState = this.getState(abstractIoSession);
            switch (sessionState) {
                case OPENED: {
                    try {
                        boolean bl = this.flushNow(abstractIoSession, l);
                        if (!bl || abstractIoSession.getWriteRequestQueue().isEmpty(abstractIoSession) || abstractIoSession.isScheduledForFlush()) break;
                        this.scheduleFlush(abstractIoSession);
                    }
                    catch (Exception exception) {
                        this.scheduleRemove(abstractIoSession);
                        IoFilterChain ioFilterChain = abstractIoSession.getFilterChain();
                        ioFilterChain.fireExceptionCaught(exception);
                    }
                    break;
                }
                case CLOSING: {
                    break;
                }
                case OPENING: {
                    this.scheduleFlush(abstractIoSession);
                    return;
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)sessionState));
                }
            }
            if (!this.flushingSessions.isEmpty()) continue;
        }
    }

    private boolean flushNow(S s, long l) {
        if (!((AbstractIoSession)s).isConnected()) {
            this.scheduleRemove(s);
            return false;
        }
        boolean bl = s.getTransportMetadata().hasFragmentation();
        WriteRequestQueue writeRequestQueue = ((AbstractIoSession)s).getWriteRequestQueue();
        int n = ((AbstractIoSession)s).getConfig().getMaxReadBufferSize() + (((AbstractIoSession)s).getConfig().getMaxReadBufferSize() >>> 1);
        int n2 = 0;
        WriteRequest writeRequest = null;
        try {
            this.setInterestedInWrite(s, false);
            do {
                if ((writeRequest = ((AbstractIoSession)s).getCurrentWriteRequest()) == null) {
                    writeRequest = writeRequestQueue.poll((IoSession)s);
                    if (writeRequest == null) break;
                    ((AbstractIoSession)s).setCurrentWriteRequest(writeRequest);
                }
                int n3 = 0;
                Object object = writeRequest.getMessage();
                if (object instanceof IoBuffer) {
                    n3 = this.writeBuffer(s, writeRequest, bl, n - n2, l);
                    if (n3 > 0 && ((IoBuffer)object).hasRemaining()) {
                        n2 += n3;
                        this.setInterestedInWrite(s, true);
                        return false;
                    }
                } else if (object instanceof FileRegion) {
                    n3 = this.writeFile(s, writeRequest, bl, n - n2, l);
                    if (n3 > 0 && ((FileRegion)object).getRemainingBytes() > 0L) {
                        n2 += n3;
                        this.setInterestedInWrite(s, true);
                        return false;
                    }
                } else {
                    throw new IllegalStateException("Don't know how to handle message of type '" + object.getClass().getName() + "'.  Are you missing a protocol encoder?");
                }
                if (n3 == 0) {
                    this.setInterestedInWrite(s, true);
                    return false;
                }
                if ((n2 += n3) < n) continue;
                this.scheduleFlush(s);
                return false;
            } while (n2 < n);
        }
        catch (Exception exception) {
            if (writeRequest != null) {
                writeRequest.getFuture().setException(exception);
            }
            IoFilterChain ioFilterChain = s.getFilterChain();
            ioFilterChain.fireExceptionCaught(exception);
            return false;
        }
        return true;
    }

    private int writeBuffer(S s, WriteRequest writeRequest, boolean bl, int n, long l) throws Exception {
        int n2;
        IoBuffer ioBuffer = (IoBuffer)writeRequest.getMessage();
        int n3 = 0;
        if (ioBuffer.hasRemaining()) {
            n2 = bl ? Math.min(ioBuffer.remaining(), n) : ioBuffer.remaining();
            n3 = this.write(s, ioBuffer, n2);
        }
        ((AbstractIoSession)s).increaseWrittenBytes(n3, l);
        if (!ioBuffer.hasRemaining() || !bl && n3 != 0) {
            n2 = ioBuffer.position();
            ioBuffer.reset();
            this.fireMessageSent(s, writeRequest);
            ioBuffer.position(n2);
        }
        return n3;
    }

    private int writeFile(S s, WriteRequest writeRequest, boolean bl, int n, long l) throws Exception {
        int n2;
        FileRegion fileRegion = (FileRegion)writeRequest.getMessage();
        if (fileRegion.getRemainingBytes() > 0L) {
            int n3 = bl ? (int)Math.min(fileRegion.getRemainingBytes(), (long)n) : (int)Math.min(Integer.MAX_VALUE, fileRegion.getRemainingBytes());
            n2 = this.transferFile(s, fileRegion, n3);
            fileRegion.update(n2);
        } else {
            n2 = 0;
        }
        ((AbstractIoSession)s).increaseWrittenBytes(n2, l);
        if (fileRegion.getRemainingBytes() <= 0L || !bl && n2 != 0) {
            this.fireMessageSent(s, writeRequest);
        }
        return n2;
    }

    private void fireMessageSent(S s, WriteRequest writeRequest) {
        ((AbstractIoSession)s).setCurrentWriteRequest(null);
        IoFilterChain ioFilterChain = s.getFilterChain();
        ioFilterChain.fireMessageSent(writeRequest);
    }

    private void updateTrafficMask() {
        block5: for (int i = this.trafficControllingSessions.size(); i > 0; --i) {
            AbstractIoSession abstractIoSession = (AbstractIoSession)this.trafficControllingSessions.poll();
            if (abstractIoSession == null) {
                return;
            }
            SessionState sessionState = this.getState(abstractIoSession);
            switch (sessionState) {
                case OPENED: {
                    this.updateTrafficControl(abstractIoSession);
                    continue block5;
                }
                case CLOSING: {
                    continue block5;
                }
                case OPENING: {
                    this.trafficControllingSessions.add(abstractIoSession);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)sessionState));
                }
            }
        }
    }

    public void updateTrafficControl(S s) {
        IoFilterChain ioFilterChain;
        try {
            this.setInterestedInRead(s, !((AbstractIoSession)s).isReadSuspended());
        }
        catch (Exception exception) {
            ioFilterChain = s.getFilterChain();
            ioFilterChain.fireExceptionCaught(exception);
        }
        try {
            this.setInterestedInWrite(s, !((AbstractIoSession)s).getWriteRequestQueue().isEmpty((IoSession)s) && !((AbstractIoSession)s).isWriteSuspended());
        }
        catch (Exception exception) {
            ioFilterChain = s.getFilterChain();
            ioFilterChain.fireExceptionCaught(exception);
        }
    }

    private class Processor
    implements Runnable {
        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = 0;
            AbstractPollingIoProcessor.this.lastIdleCheckTime = System.currentTimeMillis();
            block15: while (true) {
                try {
                    while (true) {
                        Iterator iterator;
                        int n2 = AbstractPollingIoProcessor.this.select(1000L);
                        n += AbstractPollingIoProcessor.this.handleNewSessions();
                        AbstractPollingIoProcessor.this.updateTrafficMask();
                        if (n2 > 0) {
                            AbstractPollingIoProcessor.this.process();
                        }
                        long l = System.currentTimeMillis();
                        AbstractPollingIoProcessor.this.flush(l);
                        AbstractPollingIoProcessor.this.notifyIdleSessions(l);
                        if ((n -= AbstractPollingIoProcessor.this.removeSessions()) == 0) {
                            iterator = AbstractPollingIoProcessor.this.lock;
                            synchronized (iterator) {
                                if (AbstractPollingIoProcessor.this.newSessions.isEmpty() && AbstractPollingIoProcessor.this.isSelectorEmpty()) {
                                    AbstractPollingIoProcessor.this.processor = null;
                                    break block15;
                                }
                            }
                        }
                        if (!AbstractPollingIoProcessor.this.isDisposing()) continue;
                        iterator = AbstractPollingIoProcessor.this.allSessions();
                        while (iterator.hasNext()) {
                            AbstractPollingIoProcessor.this.scheduleRemove((AbstractIoSession)iterator.next());
                        }
                        AbstractPollingIoProcessor.this.wakeup();
                    }
                }
                catch (Throwable throwable) {
                    ExceptionMonitor.getInstance().exceptionCaught(throwable);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        ExceptionMonitor.getInstance().exceptionCaught(interruptedException);
                    }
                    continue;
                }
                break;
            }
            try {
                Object object = AbstractPollingIoProcessor.this.disposalLock;
                synchronized (object) {
                    if (AbstractPollingIoProcessor.this.disposing) {
                        AbstractPollingIoProcessor.this.doDispose();
                    }
                }
            }
            catch (Throwable throwable) {
                ExceptionMonitor.getInstance().exceptionCaught(throwable);
            }
            finally {
                AbstractPollingIoProcessor.this.disposalFuture.setValue(true);
            }
        }
    }
}

