/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.buffer;

import org.apache.mina.core.buffer.IoBuffer;

class IoBufferHexDumper {
    private static final byte[] highDigits;
    private static final byte[] lowDigits;

    public static String getHexdump(IoBuffer ioBuffer, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("lengthLimit: " + n + " (expected: 1+)");
        }
        boolean bl = ioBuffer.remaining() > n;
        int n2 = bl ? n : ioBuffer.remaining();
        if (n2 == 0) {
            return "empty";
        }
        StringBuilder stringBuilder = new StringBuilder(n2 * 3 + 3);
        int n3 = ioBuffer.position();
        int n4 = ioBuffer.get() & 0xFF;
        stringBuilder.append((char)highDigits[n4]);
        stringBuilder.append((char)lowDigits[n4]);
        --n2;
        while (n2 > 0) {
            stringBuilder.append(' ');
            n4 = ioBuffer.get() & 0xFF;
            stringBuilder.append((char)highDigits[n4]);
            stringBuilder.append((char)lowDigits[n4]);
            --n2;
        }
        ioBuffer.position(n3);
        if (bl) {
            stringBuilder.append("...");
        }
        return stringBuilder.toString();
    }

    static {
        byte[] byArray = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray2[i] = byArray[i >>> 4];
            byArray3[i] = byArray[i & 0xF];
        }
        highDigits = byArray2;
        lowDigits = byArray3;
    }
}

