/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceToolBarBorder
extends AbstractBorder
implements UIResource {
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(n, n2);
        if (((JToolBar)component).isFloatable()) {
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
            int n5 = (int)(0.75 * (double)SubstanceSizeUtils.getToolBarDragInset(SubstanceSizeUtils.getComponentFontSize(component)));
            if (((JToolBar)component).getOrientation() == 0) {
                int n6 = component.getHeight() - 4;
                if (n6 > 0) {
                    if (component.getComponentOrientation().isLeftToRight()) {
                        graphics2D.drawImage((Image)SubstanceImageCreator.getDragImage(component, substanceColorScheme, n5, n6, 2), 2, 1, null);
                    } else {
                        graphics2D.drawImage((Image)SubstanceImageCreator.getDragImage(component, substanceColorScheme, n5, n6, 2), component.getBounds().width - n5 - 2, 1, null);
                    }
                }
            } else {
                int n7 = component.getWidth() - 4;
                if (n7 > 0) {
                    graphics2D.drawImage((Image)SubstanceImageCreator.getDragImage(component, substanceColorScheme, n7, n5, 2), 2, 2, null);
                }
            }
        }
        graphics2D.translate(-n, -n2);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2;
        Insets insets3 = SubstanceSizeUtils.getToolBarInsets(SubstanceSizeUtils.getComponentFontSize(component));
        insets.set(insets3.top, insets3.left, insets3.bottom, insets3.right);
        JToolBar jToolBar = (JToolBar)component;
        if (jToolBar.isFloatable()) {
            int n = SubstanceSizeUtils.getToolBarDragInset(SubstanceSizeUtils.getComponentFontSize(component));
            if (jToolBar.getOrientation() == 0) {
                if (jToolBar.getComponentOrientation().isLeftToRight()) {
                    insets.left = n;
                } else {
                    insets.right = n;
                }
            } else {
                insets.top = n;
            }
        }
        if ((insets2 = jToolBar.getMargin()) != null) {
            insets.left += insets2.left;
            insets.top += insets2.top;
            insets.right += insets2.right;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }
}

