/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.MenuArrowIcon;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenu;

public class SubstanceMenuUI
extends BasicMenuUI
implements SubstanceMenu,
TransitionAwareUI {
    protected boolean containerGhostingMarker;
    protected Set lafWidgets;
    protected MouseListener substanceMouseListener;
    protected StateTransitionTracker stateTransitionTracker;
    protected MenuUtilities.MenuPropertyListener substanceMenuPropertyListener;
    protected PropertyChangeListener substancePropertyListener;
    protected FocusListener substanceFocusListener;

    @Override
    protected void update(Graphics graphics, JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceMenuUI__container__update(graphics, jComponent);
        GhostPaintingUtils.paintGhostImages(jComponent, graphics);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceMenuUI__installComponents(JMenuItem jMenuItem) {
        super.installComponents(jMenuItem);
    }

    @Override
    protected void installComponents(JMenuItem jMenuItem) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceMenuUI__installComponents(jMenuItem);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceMenuUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceMenuUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceMenuUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceMenuUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceMenuUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceMenuUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceMenuUI__uninstallComponents(JMenuItem jMenuItem) {
        super.uninstallComponents(jMenuItem);
    }

    @Override
    protected void uninstallComponents(JMenuItem jMenuItem) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceMenuUI__uninstallComponents(jMenuItem);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceMenuUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceMenuUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceMenuUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceMenuUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceMenuUI__container__update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceMenuUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceMenuUI((JMenu)jComponent);
    }

    public SubstanceMenuUI(JMenu jMenu) {
        this.stateTransitionTracker = new StateTransitionTracker(jMenu, jMenu.getModel());
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceMenuUI__installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
        this.arrowIcon = new MenuArrowIcon((JMenu)this.menuItem);
        this.defaultTextIconGap = SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(this.menuItem));
        this.menuItem.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.FALSE);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceMenuUI__installListeners() {
        super.installListeners();
        this.substanceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.substanceMenuPropertyListener.install();
        this.stateTransitionTracker.registerModelListeners();
        this.substanceMouseListener = new MouseAdapter(){

            private boolean toRepaint() {
                MenuElement[] menuElementArray;
                for (MenuElement menuElement : menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (menuElement != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return menuElementArray.length == 0;
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.stateTransitionTracker.turnOffModelChangeTracking();
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(true);
                    SubstanceMenuUI.this.stateTransitionTracker.onModelStateChanged();
                    Rectangle rectangle = SubstanceMenuUI.this.menuItem.getBounds();
                    SubstanceMenuUI.this.menuItem.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.stateTransitionTracker.turnOffModelChangeTracking();
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    SubstanceMenuUI.this.stateTransitionTracker.onModelStateChanged();
                    Rectangle rectangle = SubstanceMenuUI.this.menuItem.getBounds();
                    SubstanceMenuUI.this.menuItem.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        };
        this.menuItem.addMouseListener(this.substanceMouseListener);
        this.substanceFocusListener = new FocusAdapter(){

            private boolean toRepaint() {
                MenuElement[] menuElementArray;
                for (MenuElement menuElement : menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (menuElement != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return menuElementArray.length == 0;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.stateTransitionTracker.turnOffModelChangeTracking();
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    SubstanceMenuUI.this.stateTransitionTracker.onModelStateChanged();
                    Rectangle rectangle = SubstanceMenuUI.this.menuItem.getBounds();
                    SubstanceMenuUI.this.menuItem.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        };
        this.menuItem.addFocusListener(this.substanceFocusListener);
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("model".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceMenuUI.this.stateTransitionTracker.setModel((ButtonModel)propertyChangeEvent.getNewValue());
                }
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SubstanceMenuUI.this.menuItem != null) {
                                SubstanceMenuUI.this.menuItem.updateUI();
                            }
                        }
                    });
                }
            }
        };
        this.menuItem.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceMenuUI__uninstallListeners() {
        super.uninstallListeners();
        this.substanceMenuPropertyListener.uninstall();
        this.substanceMenuPropertyListener = null;
        this.menuItem.removeMouseListener(this.substanceMouseListener);
        this.substanceMouseListener = null;
        this.menuItem.removeFocusListener(this.substanceFocusListener);
        this.substanceFocusListener = null;
        this.menuItem.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
    }

    @Override
    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    @Override
    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    @Override
    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    @Override
    public Icon getCheckIcon() {
        return null;
    }

    @Override
    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        Dimension dimension = super.getPreferredMenuItemSize(jComponent, icon, icon2, n);
        if (MenuUtilities.getPopupLayoutMetrics(this.menuItem, false) != null) {
            return new Dimension(MenuUtilities.getPreferredWidth(this.menuItem), dimension.height);
        }
        return dimension;
    }

    @Override
    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        MenuUtilities.paintMenuItem(graphics, this.menuItem, icon, icon2, n);
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        return true;
    }
}

