/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeCellRenderer;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.ui.SubstanceTreeUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;

@SubstanceRenderer
public class SubstanceDefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private JTree tree;
    protected boolean selected;
    protected boolean hasFocus;

    public SubstanceDefaultTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.putClientProperty("substancelaf.colorizationFactor", 1.0);
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        SubstanceTreeUI substanceTreeUI;
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.tree = jTree;
        this.hasFocus = bl4;
        this.setText(string);
        TreeUI treeUI = jTree.getUI();
        if (treeUI instanceof SubstanceTreeUI) {
            boolean bl5;
            substanceTreeUI = (SubstanceTreeUI)treeUI;
            object2 = new SubstanceTreeUI.TreePathId(jTree.getPathForRow(n));
            StateTransitionTracker.ModelStateInfo modelStateInfo = substanceTreeUI.getModelStateInfo((SubstanceTreeUI.TreePathId)object2);
            ComponentState componentState = substanceTreeUI.getPathState((SubstanceTreeUI.TreePathId)object2);
            JTree.DropLocation dropLocation = jTree.getDropLocation();
            boolean bl6 = bl5 = dropLocation != null && dropLocation.getChildIndex() == -1 && jTree.getRowForPath(dropLocation.getPath()) == n;
            if (!bl5 && modelStateInfo != null) {
                Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
                SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jTree, substanceTreeUI, componentState);
                if (componentState.isDisabled() || map == null || map.size() == 1) {
                    super.setForeground(new ColorUIResource(substanceColorScheme.getForegroundColor()));
                } else {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState componentState2 = entry.getKey();
                        SubstanceColorScheme substanceColorScheme2 = this.getColorSchemeForState(jTree, substanceTreeUI, componentState2);
                        Color color = substanceColorScheme2.getForegroundColor();
                        float f4 = entry.getValue().getContribution();
                        f += (float)color.getRed() * f4;
                        f2 += (float)color.getGreen() * f4;
                        f3 += (float)color.getBlue() * f4;
                    }
                    super.setForeground(new ColorUIResource(new Color((int)f, (int)f2, (int)f3)));
                }
            } else {
                SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jTree, substanceTreeUI, componentState);
                if (bl5) {
                    substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jTree, ColorSchemeAssociationKind.TEXT_HIGHLIGHT, componentState);
                }
                super.setForeground(new ColorUIResource(substanceColorScheme.getForegroundColor()));
            }
        } else if (bl) {
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
        } else {
            this.setForeground(UIManager.getColor("Tree.textForeground"));
        }
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            SubstanceStripingUtils.applyStripedBackground(jTree, n, this);
        }
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            if (bl3) {
                this.setDisabledIcon(SubstanceImageCreator.toGreyscale(SubstanceImageCreator.makeTransparent(jTree, this.getDefaultLeafIcon(), 0.5)));
            } else if (bl2) {
                this.setDisabledIcon(SubstanceImageCreator.toGreyscale(SubstanceImageCreator.makeTransparent(jTree, this.getDefaultOpenIcon(), 0.5)));
            } else {
                this.setDisabledIcon(SubstanceImageCreator.toGreyscale(SubstanceImageCreator.makeTransparent(jTree, this.getDefaultClosedIcon(), 0.5)));
            }
        } else {
            this.setEnabled(true);
            if (bl3) {
                this.setIcon(this.getDefaultLeafIcon());
            } else if (bl2) {
                this.setIcon(this.getDefaultOpenIcon());
            } else {
                this.setIcon(this.getDefaultClosedIcon());
            }
        }
        this.setComponentOrientation(jTree.getComponentOrientation());
        this.setOpaque(false);
        this.selected = bl;
        if (treeUI instanceof SubstanceTreeUI) {
            substanceTreeUI = (SubstanceTreeUI)treeUI;
            object2 = substanceTreeUI.getCellRendererInsets();
            this.setBorder(new BorderUIResource.EmptyBorderUIResource((Insets)object2));
        }
        return this;
    }

    private SubstanceColorScheme getColorSchemeForState(JTree jTree, SubstanceTreeUI substanceTreeUI, ComponentState componentState) {
        SubstanceColorScheme substanceColorScheme;
        SubstanceColorScheme substanceColorScheme2 = substanceColorScheme = componentState == ComponentState.ENABLED ? substanceTreeUI.getDefaultColorScheme() : SubstanceColorSchemeUtilities.getColorScheme(jTree, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
        if (substanceColorScheme == null) {
            substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jTree, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
        }
        return substanceColorScheme;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("text".equals(string)) {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }
}

