/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.ui.SubstanceListUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationInfo;

@SubstanceRenderer
public class SubstanceDefaultListCellRenderer
extends DefaultListCellRenderer {
    public SubstanceDefaultListCellRenderer() {
        this.putClientProperty("substancelaf.colorizationFactor", 1.0);
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Object object2;
        this.setComponentOrientation(jList.getComponentOrientation());
        ListUI listUI = jList.getUI();
        if (listUI instanceof SubstanceListUI) {
            boolean bl3;
            object2 = (SubstanceListUI)listUI;
            StateTransitionTracker.ModelStateInfo modelStateInfo = ((SubstanceListUI)object2).getModelStateInfo(n, this);
            ComponentState componentState = ((SubstanceListUI)object2).getCellState(n, this);
            JList.DropLocation dropLocation = jList.getDropLocation();
            boolean bl4 = bl3 = dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == n;
            if (!bl3 && modelStateInfo != null) {
                Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
                SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jList, (SubstanceListUI)object2, componentState);
                if (componentState.isDisabled() || map == null || map.size() == 1) {
                    super.setForeground(new ColorUIResource(substanceColorScheme.getForegroundColor()));
                } else {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState componentState2 = entry.getKey();
                        SubstanceColorScheme substanceColorScheme2 = this.getColorSchemeForState(jList, (SubstanceListUI)object2, componentState2);
                        Color color = substanceColorScheme2.getForegroundColor();
                        float f4 = entry.getValue().getContribution();
                        f += (float)color.getRed() * f4;
                        f2 += (float)color.getGreen() * f4;
                        f3 += (float)color.getBlue() * f4;
                    }
                    super.setForeground(new ColorUIResource(new Color((int)f, (int)f2, (int)f3)));
                }
            } else {
                SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jList, (SubstanceListUI)object2, componentState);
                if (bl3) {
                    substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jList, ColorSchemeAssociationKind.TEXT_HIGHLIGHT, componentState);
                }
                super.setForeground(new ColorUIResource(substanceColorScheme.getForegroundColor()));
            }
        } else if (bl) {
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setForeground(jList.getForeground());
        }
        if (SubstanceLookAndFeel.isCurrentLookAndFeel() && jList.getLayoutOrientation() == 0) {
            SubstanceStripingUtils.applyStripedBackground(jList, n, this);
        }
        if (object instanceof Icon) {
            this.setIcon((Icon)object);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(object == null ? "" : object.toString());
        }
        this.setEnabled(jList.isEnabled());
        this.setFont(jList.getFont());
        object2 = SubstanceSizeUtils.getListCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(jList));
        this.setBorder(new EmptyBorder(((Insets)object2).top, ((Insets)object2).left, ((Insets)object2).bottom, ((Insets)object2).right));
        this.setOpaque(false);
        return this;
    }

    private SubstanceColorScheme getColorSchemeForState(JList jList, SubstanceListUI substanceListUI, ComponentState componentState) {
        UpdateOptimizationInfo updateOptimizationInfo = substanceListUI.getUpdateOptimizationInfo();
        if (componentState == ComponentState.ENABLED) {
            if (updateOptimizationInfo == null) {
                return SubstanceColorSchemeUtilities.getColorScheme(jList, componentState);
            }
            return updateOptimizationInfo.getDefaultScheme();
        }
        if (updateOptimizationInfo == null) {
            return SubstanceColorSchemeUtilities.getColorScheme(jList, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
        }
        return updateOptimizationInfo.getHighlightColorScheme(componentState);
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    @Override
    public final void paintComponents(Graphics graphics) {
        super.paintComponents(graphics);
    }

    @Override
    protected final void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
    }

    public static class SubstanceUIResource
    extends SubstanceDefaultListCellRenderer
    implements UIResource {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent(jList, object, n, bl, bl2);
        }
    }
}

