/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.api.renderers.SubstanceRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.ui.SubstanceComboBoxUI;
import org.pushingpixels.substance.internal.ui.SubstanceListUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationInfo;

@SubstanceRenderer
public class SubstanceDefaultComboBoxRenderer
extends SubstanceDefaultListCellRenderer {
    private JComboBox combo;

    public SubstanceDefaultComboBoxRenderer(JComboBox jComboBox) {
        this.combo = jComboBox;
        Insets insets = SubstanceSizeUtils.getListCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(jComboBox));
        this.setBorder(new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JComponent jComponent = (JComponent)super.getListCellRendererComponent(jList, object, n, bl, bl2);
        ListUI listUI = jList.getUI();
        ComboBoxUI comboBoxUI = this.combo.getUI();
        if (listUI instanceof SubstanceListUI && comboBoxUI instanceof SubstanceComboBoxUI) {
            SubstanceListUI substanceListUI = (SubstanceListUI)listUI;
            SubstanceComboBoxUI substanceComboBoxUI = (SubstanceComboBoxUI)comboBoxUI;
            if (n == -1) {
                StateTransitionTracker stateTransitionTracker = substanceComboBoxUI.getTransitionTracker();
                StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
                ComponentState componentState = modelStateInfo.getCurrModelState();
                float f = SubstanceColorSchemeUtilities.getAlpha(this.combo, componentState);
                Color color = SubstanceTextUtilities.getForegroundColor((JComponent)this.combo, ((JLabel)jComponent).getText(), modelStateInfo, f);
                jComponent.setForeground(color);
            } else {
                StateTransitionTracker.ModelStateInfo modelStateInfo = substanceListUI.getModelStateInfo(n, jComponent);
                ComponentState componentState = substanceListUI.getCellState(n, jComponent);
                if (modelStateInfo == null) {
                    SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jList, n, substanceListUI, componentState);
                    jComponent.setForeground(new ColorUIResource(substanceColorScheme.getForegroundColor()));
                } else {
                    Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
                    SubstanceColorScheme substanceColorScheme = this.getColorSchemeForState(jList, n, substanceListUI, componentState);
                    if (componentState.isDisabled() || map == null || map.size() == 1) {
                        super.setForeground(new ColorUIResource(substanceColorScheme.getForegroundColor()));
                    } else {
                        float f = 0.0f;
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : modelStateInfo.getStateContributionMap().entrySet()) {
                            ComponentState componentState2 = entry.getKey();
                            float f4 = entry.getValue().getContribution();
                            if (f4 == 0.0f) continue;
                            SubstanceColorScheme substanceColorScheme2 = this.getColorSchemeForState(jList, n, substanceListUI, componentState2);
                            Color color = substanceColorScheme2.getForegroundColor();
                            f += (float)color.getRed() * f4;
                            f2 += (float)color.getGreen() * f4;
                            f3 += (float)color.getBlue() * f4;
                        }
                        jComponent.setForeground(new ColorUIResource(new Color((int)f, (int)f2, (int)f3)));
                    }
                }
            }
            SubstanceStripingUtils.applyStripedBackground(jList, n, this);
        }
        jComponent.setEnabled(this.combo.isEnabled());
        return jComponent;
    }

    private SubstanceColorScheme getColorSchemeForState(JList jList, int n, SubstanceListUI substanceListUI, ComponentState componentState) {
        boolean bl = n >= 0 && (componentState.isFacetActive(ComponentStateFacet.ROLLOVER) || componentState.isFacetActive(ComponentStateFacet.SELECTION));
        UpdateOptimizationInfo updateOptimizationInfo = substanceListUI.getUpdateOptimizationInfo();
        if (bl) {
            if (updateOptimizationInfo == null) {
                return SubstanceColorSchemeUtilities.getColorScheme(jList, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
            }
            return updateOptimizationInfo.getHighlightColorScheme(componentState);
        }
        if (updateOptimizationInfo == null) {
            return SubstanceColorSchemeUtilities.getColorScheme(jList, componentState);
        }
        return updateOptimizationInfo.getDefaultScheme();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension;
        if (this.getText() == null || this.getText().equals("")) {
            this.setText(" ");
            dimension = super.getPreferredSize();
            this.setText("");
        } else {
            dimension = super.getPreferredSize();
        }
        return dimension;
    }

    public static class SubstanceUIResource
    extends SubstanceDefaultComboBoxRenderer
    implements UIResource {
        public SubstanceUIResource(JComboBox jComboBox) {
            super(jComboBox);
        }
    }
}

