/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.option;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.Parent;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.option.HelpLineImpl;
import org.apache.commons.cli2.option.OptionImpl;

public abstract class ParentImpl
extends OptionImpl
implements Parent {
    private static final char NUL = '\u0000';
    private final Group children;
    private final Argument argument;
    private final String description;

    protected ParentImpl(Argument argument, Group children, String description, int id, boolean required) {
        super(id, required);
        this.children = children;
        this.argument = argument;
        this.description = description;
    }

    @Override
    public void process(WriteableCommandLine commandLine, ListIterator arguments) throws OptionException {
        if (this.argument != null) {
            this.handleInitialSeparator(arguments, this.argument.getInitialSeparator());
        }
        this.processParent(commandLine, arguments);
        if (this.argument != null) {
            this.argument.processValues(commandLine, arguments, this);
        }
        if (this.children != null && this.children.canProcess(commandLine, arguments)) {
            this.children.process(commandLine, arguments);
        }
    }

    @Override
    public boolean canProcess(WriteableCommandLine commandLine, String arg) {
        int initialIndex;
        char separator;
        Set triggers = this.getTriggers();
        if (this.argument != null && (separator = this.argument.getInitialSeparator()) != '\u0000' && (initialIndex = arg.indexOf(separator)) > 0) {
            return triggers.contains(arg.substring(0, initialIndex));
        }
        return triggers.contains(arg);
    }

    @Override
    public Set getPrefixes() {
        return this.children == null ? Collections.EMPTY_SET : this.children.getPrefixes();
    }

    @Override
    public void validate(WriteableCommandLine commandLine) throws OptionException {
        if (commandLine.hasOption(this)) {
            if (this.argument != null) {
                this.argument.validate(commandLine, this);
            }
            if (this.children != null) {
                this.children.validate(commandLine);
            }
        }
    }

    @Override
    public void appendUsage(StringBuffer buffer, Set helpSettings, Comparator comp) {
        boolean displayChildren;
        boolean displayArgument = this.argument != null && helpSettings.contains(DisplaySetting.DISPLAY_PARENT_ARGUMENT);
        boolean bl = displayChildren = this.children != null && helpSettings.contains(DisplaySetting.DISPLAY_PARENT_CHILDREN);
        if (displayArgument) {
            buffer.append(' ');
            this.argument.appendUsage(buffer, helpSettings, comp);
        }
        if (displayChildren) {
            buffer.append(' ');
            this.children.appendUsage(buffer, helpSettings, comp);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List helpLines(int depth, Set helpSettings, Comparator comp) {
        ArrayList<HelpLineImpl> helpLines = new ArrayList<HelpLineImpl>();
        helpLines.add(new HelpLineImpl(this, depth));
        if (helpSettings.contains(DisplaySetting.DISPLAY_PARENT_ARGUMENT) && this.argument != null) {
            helpLines.addAll(this.argument.helpLines(depth + 1, helpSettings, comp));
        }
        if (helpSettings.contains(DisplaySetting.DISPLAY_PARENT_CHILDREN) && this.children != null) {
            helpLines.addAll(this.children.helpLines(depth + 1, helpSettings, comp));
        }
        return helpLines;
    }

    public Argument getArgument() {
        return this.argument;
    }

    public Group getChildren() {
        return this.children;
    }

    private void handleInitialSeparator(ListIterator arguments, char separator) {
        String newArgument = (String)arguments.next();
        int initialIndex = newArgument.indexOf(separator);
        if (initialIndex > 0) {
            arguments.remove();
            arguments.add(newArgument.substring(0, initialIndex));
            String value = newArgument.substring(initialIndex + 1);
            if (value.startsWith("-")) {
                value = '\"' + value + '\"';
            }
            arguments.add(value);
            arguments.previous();
        }
        arguments.previous();
    }

    @Override
    public Option findOption(String trigger) {
        Option found = super.findOption(trigger);
        if (found == null && this.children != null) {
            return this.children.findOption(trigger);
        }
        return found;
    }

    @Override
    public void defaults(WriteableCommandLine commandLine) {
        super.defaults(commandLine);
        if (this.argument != null) {
            this.argument.defaultValues(commandLine, this);
        }
        if (this.children != null) {
            this.children.defaults(commandLine);
        }
    }
}

