/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.osx.OSXFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FileRenderer
extends JPanel
implements ListCellRenderer {
    private Color labelForeground;
    private Color labelDisabledForeground;
    private Icon selectedExpandingIcon;
    private Icon selectedExpandedIcon;
    private Icon focusedSelectedExpandingIcon;
    private Icon focusedSelectedExpandedIcon;
    private Icon expandingIcon;
    private Icon expandedIcon;
    private Icon emptyIcon;
    private JFileChooser fileChooser;
    private Icon icon;
    private String text;
    private Icon arrowIcon;
    private Color labelColor;
    private Color labelBrightColor;
    private boolean isSelected;
    private boolean isGrayed;
    private static final Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle arrowIconRect = new Rectangle();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle r = new Rectangle();
    private static final int textIconGap = 5;

    public FileRenderer(JFileChooser fileChooser, Icon expandingIcon, Icon expandedIcon, Icon selectedExpandingIcon, Icon selectedExpandedIcon, Icon focusedSelectedExpandingIcon, Icon focusedSelectedExpandedIcon) {
        this.fileChooser = fileChooser;
        this.expandingIcon = expandingIcon;
        this.expandedIcon = expandedIcon;
        this.selectedExpandingIcon = selectedExpandingIcon;
        this.selectedExpandedIcon = selectedExpandedIcon;
        this.focusedSelectedExpandingIcon = focusedSelectedExpandingIcon;
        this.focusedSelectedExpandedIcon = focusedSelectedExpandedIcon;
        this.emptyIcon = new Icon(){

            public int getIconWidth() {
                return FileRenderer.this.expandedIcon.getIconWidth();
            }

            public int getIconHeight() {
                return FileRenderer.this.expandedIcon.getIconHeight();
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
        this.labelForeground = UIManager.getColor("Label.foreground");
        this.labelDisabledForeground = UIManager.getColor("Label.disabledForeground");
        this.setOpaque(true);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Integer viewTooltipRow = (Integer)list.getClientProperty("ViewTooltips.row");
        FileInfo info = (FileInfo)value;
        File file = info.getFile();
        this.isGrayed = info.isHidden() || !info.isAcceptable();
        this.labelColor = OSXFile.getLabelColor(info.getFileLabel(), this.isGrayed ? 2 : 0);
        this.labelBrightColor = OSXFile.getLabelColor(info.getFileLabel(), this.isGrayed ? 3 : 1);
        this.isSelected = isSelected;
        if (this.isSelected) {
            if (list.hasFocus() && QuaquaUtilities.isOnActiveWindow(list)) {
                this.setBackground(UIManager.getColor("Browser.selectionBackground"));
                this.setForeground(this.isGrayed ? this.labelDisabledForeground : UIManager.getColor("Browser.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("Browser.inactiveSelectionBackground"));
                this.setForeground(UIManager.getColor("Browser.inactiveSelectionForeground"));
            }
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(this.isGrayed ? this.labelDisabledForeground : this.labelForeground);
        }
        this.arrowIcon = this.isSelected && this.labelColor == null ? (QuaquaUtilities.isFocused(list) ? (info.isValidating() ? this.focusedSelectedExpandingIcon : this.focusedSelectedExpandedIcon) : (info.isValidating() ? this.selectedExpandingIcon : this.selectedExpandedIcon)) : (info.isValidating() ? this.expandingIcon : this.expandedIcon);
        this.text = info.getUserName();
        this.icon = info.getIcon();
        if (!info.isTraversable()) {
            this.arrowIcon = this.labelColor == null ? null : this.emptyIcon;
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setBorder(cellHasFocus ? UIManager.getBorder("FileChooser.browserFocusCellHighlightBorder") : UIManager.getBorder("FileChooser.browserCellBorder"));
        return this;
    }

    protected void paintComponent(Graphics gr) {
        Object oldHints = QuaquaUtilities.beginGraphics((Graphics2D)gr);
        Graphics2D g = (Graphics2D)gr;
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        boolean isUseArrow = this.arrowIcon != null;
        this.resetRects();
        viewRect.setBounds(0, 0, width, height);
        FileRenderer.viewRect.x += insets.left;
        FileRenderer.viewRect.y += insets.top;
        FileRenderer.viewRect.width -= insets.right + FileRenderer.viewRect.x;
        FileRenderer.viewRect.height -= insets.bottom + FileRenderer.viewRect.y;
        Font textFont = this.getFont();
        g.setFont(textFont);
        FontMetrics textFM = g.getFontMetrics(textFont);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        boolean isLeftToRight = QuaquaUtilities.isLeftToRight(this);
        String clippedText = this.layoutRenderer(textFM, this.text, this.icon, this.arrowIcon, viewRect, iconRect, textRect, arrowIconRect, this.text == null ? 0 : 5, 5);
        if (this.labelColor != null) {
            if (this.isSelected) {
                FileRenderer.r.y = FileRenderer.viewRect.y;
                FileRenderer.r.width = FileRenderer.r.height = FileRenderer.viewRect.height - 1;
                FileRenderer.r.x = FileRenderer.arrowIconRect.x - (FileRenderer.arrowIconRect.width - FileRenderer.r.width) / 2;
            } else {
                FileRenderer.r.x = FileRenderer.textRect.x - 5;
                FileRenderer.r.y = FileRenderer.viewRect.y - 1;
                FileRenderer.r.width = FileRenderer.viewRect.width - FileRenderer.r.x;
                FileRenderer.r.height = FileRenderer.viewRect.height + 1;
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setPaint(new GradientPaint(FileRenderer.r.x, FileRenderer.r.y, this.labelBrightColor, FileRenderer.r.x, FileRenderer.r.y + FileRenderer.r.height, this.labelColor));
            g.fillRoundRect(FileRenderer.r.x, FileRenderer.r.y, FileRenderer.r.width, FileRenderer.r.height, FileRenderer.r.height, FileRenderer.r.height);
        }
        if (this.icon != null) {
            this.icon.paintIcon(this, g, FileRenderer.iconRect.x, FileRenderer.iconRect.y);
        }
        if (clippedText != null && !clippedText.equals("")) {
            g.setColor(this.getForeground());
            g.drawString(clippedText, FileRenderer.textRect.x, FileRenderer.textRect.y + textFM.getAscent());
        }
        if (this.arrowIcon != null) {
            this.arrowIcon.paintIcon(this, g, FileRenderer.arrowIconRect.x, FileRenderer.arrowIconRect.y);
        }
        QuaquaUtilities.endGraphics(g, oldHints);
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    public Dimension getPreferredSize() {
        Insets insets;
        boolean isUseArrow;
        Font textFont = this.getFont();
        FontMetrics textFM = this.getFontMetrics(textFont);
        this.resetRects();
        this.layoutRenderer(textFM, this.text, this.icon, this.arrowIcon, viewRect, iconRect, textRect, arrowIconRect, this.text == null ? 0 : 5, 5);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(FileRenderer.iconRect.x, FileRenderer.iconRect.y, FileRenderer.iconRect.width, FileRenderer.iconRect.height, r);
        boolean bl = isUseArrow = this.arrowIcon != null;
        if (isUseArrow) {
            FileRenderer.r.width += FileRenderer.arrowIconRect.width;
        }
        if ((insets = this.getInsets()) != null) {
            FileRenderer.r.width += insets.left + insets.right;
            FileRenderer.r.height += insets.top + insets.bottom;
        }
        return r.getSize();
    }

    private String layoutRenderer(FontMetrics textFM, String text, Icon icon, Icon arrowIcon, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle arrowIconRect, int textIconGap, int textArrowIconGap) {
        boolean isUseArrow;
        boolean bl = isUseArrow = arrowIcon != null;
        if (isUseArrow) {
            arrowIconRect.width = arrowIcon.getIconWidth();
            arrowIconRect.height = arrowIcon.getIconHeight();
            viewRect.width -= arrowIconRect.width + textIconGap;
        }
        text = QuaquaUtilities.layoutCompoundLabel(this, textFM, text, icon, 1, 2, 0, 4, viewRect, iconRect, textRect, textIconGap);
        if (isUseArrow) {
            viewRect.width += arrowIconRect.width + textIconGap;
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (isUseArrow) {
            arrowIconRect.x = viewRect.width - arrowIconRect.width;
            arrowIconRect.y = viewRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
        }
        if (!QuaquaUtilities.isLeftToRight(this)) {
            int width = viewRect.width;
            iconRect.x = width - (iconRect.x + iconRect.width);
            textRect.x = width - (textRect.x + textRect.width);
            arrowIconRect.x = width - (arrowIconRect.x + arrowIconRect.width);
        }
        return text;
    }
}

