/*
 * Galaxium Messenger
 * Copyright (C) 2007 Paul Burton <paulburton89@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace Galaxium.Protocol.Msn
{
	public enum Network
	{
		Unknown                 = 0,
		WindowsLive             = 1,
		OfficeCommunicator      = 2,
		Telephone               = 4,
		MNI                     = 8,	// Mobile Network Interop, used by Vodafone
		SMTP                    = 16,	// Jaguire, Japanese mobile interop
		Yahoo                   = 32
	}
	
	public static class MsnNetworkUtility
	{
		public static string Name (Network network)
		{
			switch (network)
			{
				//TODO: Do any of the values use something besides msnmsgr
			default:
				return "msnmsgr";
			}
		}
		
		public static Network FromName (string name)
		{
			switch (name.ToLower ())
			{
			case "msnmsgr":
				return Network.WindowsLive;
			default:
				return Network.Unknown;
			}
		}
	}
}
